/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.api.service.messaging;

import java.util.List;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.DBEventManagerConstants;
import org.apache.airavata.common.utils.DBEventService;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.messaging.core.MessagingFactory;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.Subscriber;
import org.apache.airavata.model.dbevent.DBEventMessage;
import org.apache.airavata.model.dbevent.DBEventMessageContext;
import org.apache.airavata.model.dbevent.DBEventSubscriber;
import org.apache.airavata.model.dbevent.DBEventType;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.registry.api.exception.RegistryServiceException;
import org.apache.airavata.registry.api.service.messaging.RegistryServiceDBEventHandler;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryServiceDBEventMessagingFactory {
    private static final Logger logger = LoggerFactory.getLogger(RegistryServiceDBEventMessagingFactory.class);
    private static Publisher dbEventPublisher;
    private static Subscriber registryServiceDBEventSubscriber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Publisher getDBEventPublisher() throws AiravataException {
        if (null != dbEventPublisher) return dbEventPublisher;
        Class<RegistryServiceDBEventMessagingFactory> clazz = RegistryServiceDBEventMessagingFactory.class;
        synchronized (RegistryServiceDBEventMessagingFactory.class) {
            if (null != dbEventPublisher) return dbEventPublisher;
            logger.info("Creating DB Event publisher.....");
            dbEventPublisher = MessagingFactory.getDBEventPublisher();
            logger.info("DB Event publisher created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbEventPublisher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Subscriber getDBEventSubscriber() throws AiravataException, RegistryServiceException {
        if (null != registryServiceDBEventSubscriber) return registryServiceDBEventSubscriber;
        Class<RegistryServiceDBEventMessagingFactory> clazz = RegistryServiceDBEventMessagingFactory.class;
        synchronized (RegistryServiceDBEventMessagingFactory.class) {
            if (null != registryServiceDBEventSubscriber) return registryServiceDBEventSubscriber;
            logger.info("Creating DB Event publisher.....");
            registryServiceDBEventSubscriber = MessagingFactory.getDBEventSubscriber((MessageHandler)new RegistryServiceDBEventHandler(), (String)DBEventService.REGISTRY.toString());
            logger.info("DB Event publisher created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return registryServiceDBEventSubscriber;
        }
    }

    public static boolean registerRegistryServiceWithPublishers(List<String> publisherList) throws AiravataException {
        for (String publisher : publisherList) {
            logger.info("Sending service discovery message. Publisher: " + publisher + ", Subscriber: " + DBEventService.REGISTRY.toString());
            DBEventSubscriber dbEventSubscriber = new DBEventSubscriber(DBEventService.REGISTRY.toString());
            DBEventMessageContext dbEventMessageContext = new DBEventMessageContext();
            dbEventMessageContext.setSubscriber(dbEventSubscriber);
            DBEventMessage dbEventMessage = new DBEventMessage(DBEventType.SUBSCRIBER, dbEventMessageContext, publisher);
            MessageContext messageContext = new MessageContext((TBase)dbEventMessage, MessageType.DB_EVENT, "", "");
            RegistryServiceDBEventMessagingFactory.getDBEventPublisher().publish(messageContext, DBEventManagerConstants.getRoutingKey((String)DBEventService.DB_EVENT.toString()));
        }
        return true;
    }
}

