/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.UserRealm;

public final class CurrentSession {
    private static ThreadLocal<Stack<String>> tUserIdStack = new ThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };
    private static ThreadLocal<Stack<UserRealm>> tUserRealmStack = new ThreadLocal<Stack<UserRealm>>(){

        @Override
        protected Stack<UserRealm> initialValue() {
            return new Stack<UserRealm>();
        }
    };
    private static ThreadLocal<Stack<Integer>> tTenantIdStack = new ThreadLocal<Stack<Integer>>(){

        @Override
        protected Stack<Integer> initialValue() {
            return new Stack<Integer>();
        }
    };
    private static ThreadLocal<Stack<Integer>> tCallerTenantIdStack = new ThreadLocal<Stack<Integer>>(){

        @Override
        protected Stack<Integer> initialValue() {
            return new Stack<Integer>();
        }
    };
    private static ThreadLocal<Stack<String>> tChrootStack = new ThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };
    private static ThreadLocal<Stack<UserRegistry>> tUserRegistryStack = new ThreadLocal<Stack<UserRegistry>>(){

        @Override
        protected Stack<UserRegistry> initialValue() {
            return new Stack<UserRegistry>();
        }
    };
    private static ThreadLocal<Stack<Map<String, String>>> tLocalPathMapStack = new ThreadLocal<Stack<Map<String, String>>>(){

        @Override
        protected Stack<Map<String, String>> initialValue() {
            return new Stack<Map<String, String>>();
        }
    };
    private static ThreadLocal<Map<String, Object>> tAttributes = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    private CurrentSession() {
    }

    public static String getUser() {
        Stack<String> userStack = tUserIdStack.get();
        if (userStack == null) {
            tUserIdStack.remove();
            userStack = tUserIdStack.get();
        }
        if (userStack.isEmpty()) {
            return null;
        }
        return userStack.peek();
    }

    public static void setUser(String userID) {
        Stack<String> userStack = tUserIdStack.get();
        if (userStack == null) {
            tUserIdStack.remove();
            userStack = tUserIdStack.get();
        }
        userStack.push(userID);
    }

    public static void removeUser() {
        Stack<String> userStack = tUserIdStack.get();
        if (userStack != null && !userStack.isEmpty()) {
            userStack.pop();
        }
    }

    public static UserRealm getUserRealm() {
        Stack<UserRealm> userRealmStack = tUserRealmStack.get();
        if (userRealmStack == null) {
            tUserRealmStack.remove();
            userRealmStack = tUserRealmStack.get();
        }
        if (userRealmStack.isEmpty()) {
            return null;
        }
        return userRealmStack.peek();
    }

    public static void setUserRealm(UserRealm userRealm) {
        Stack<UserRealm> userRealmStack = tUserRealmStack.get();
        if (userRealmStack == null) {
            tUserRealmStack.remove();
            userRealmStack = tUserRealmStack.get();
        }
        userRealmStack.push(userRealm);
    }

    public static void removeUserRealm() {
        Stack<UserRealm> userRealmStack = tUserRealmStack.get();
        if (userRealmStack != null && !userRealmStack.isEmpty()) {
            userRealmStack.pop();
        }
    }

    public static int getTenantId() {
        Stack<Integer> tenantIdStack = tTenantIdStack.get();
        if (tenantIdStack == null) {
            tTenantIdStack.remove();
            tenantIdStack = tTenantIdStack.get();
        }
        if (tenantIdStack.isEmpty()) {
            return -1;
        }
        return tenantIdStack.peek();
    }

    public static void setTenantId(int tenantId) {
        Stack<Integer> tenantIdStack = tTenantIdStack.get();
        if (tenantIdStack == null) {
            tTenantIdStack.remove();
            tenantIdStack = tTenantIdStack.get();
        }
        tenantIdStack.push(tenantId);
    }

    public static void removeTenantId() {
        Stack<Integer> tenantIdStack = tTenantIdStack.get();
        if (tenantIdStack != null && !tenantIdStack.isEmpty()) {
            tenantIdStack.pop();
        }
    }

    public static int getCallerTenantId() {
        Stack<Integer> tenantIdStack = tCallerTenantIdStack.get();
        if (tenantIdStack == null) {
            tCallerTenantIdStack.remove();
            tenantIdStack = tCallerTenantIdStack.get();
        }
        if (tenantIdStack.isEmpty()) {
            return -1;
        }
        return tenantIdStack.peek();
    }

    public static void setCallerTenantId(int callerTenantId) {
        Stack<Integer> tenantIdStack = tCallerTenantIdStack.get();
        if (tenantIdStack == null) {
            tCallerTenantIdStack.remove();
            tenantIdStack = tCallerTenantIdStack.get();
        }
        tenantIdStack.push(callerTenantId);
    }

    public static void removeCallerTenantId() {
        Stack<Integer> tenantIdStack = tCallerTenantIdStack.get();
        if (tenantIdStack != null && !tenantIdStack.isEmpty()) {
            tenantIdStack.pop();
        }
    }

    public static String getChroot() {
        Stack<String> chrootStack = tChrootStack.get();
        if (chrootStack == null) {
            tChrootStack.remove();
            chrootStack = tChrootStack.get();
        }
        if (chrootStack.isEmpty()) {
            return null;
        }
        return chrootStack.peek();
    }

    public static void setChroot(String chroot) {
        Stack<String> chrootStack = tChrootStack.get();
        if (chrootStack == null) {
            tChrootStack.remove();
            chrootStack = tChrootStack.get();
        }
        chrootStack.push(chroot);
    }

    public static void removeChroot() {
        Stack<String> chrootStack = tChrootStack.get();
        if (chrootStack != null && !chrootStack.isEmpty()) {
            chrootStack.pop();
        }
    }

    public static UserRegistry getUserRegistry() {
        Stack<UserRegistry> userRegistryStack = tUserRegistryStack.get();
        if (userRegistryStack == null) {
            tUserRegistryStack.remove();
            userRegistryStack = tUserRegistryStack.get();
        }
        if (userRegistryStack.isEmpty()) {
            return null;
        }
        return userRegistryStack.peek();
    }

    public static void setUserRegistry(UserRegistry userRegistry) {
        Stack<UserRegistry> userRegistryStack = tUserRegistryStack.get();
        if (userRegistryStack == null) {
            tUserRegistryStack.remove();
            userRegistryStack = tUserRegistryStack.get();
        }
        userRegistryStack.push(userRegistry);
    }

    public static void removeUserRegistry() {
        Stack<UserRegistry> userRegistryStack = tUserRegistryStack.get();
        if (userRegistryStack != null && !userRegistryStack.isEmpty()) {
            userRegistryStack.pop();
        }
    }

    public static Map<String, String> getLocalPathMap() {
        Stack<Map<String, String>> localPathMapStack = tLocalPathMapStack.get();
        if (localPathMapStack == null) {
            tLocalPathMapStack.remove();
            localPathMapStack = tLocalPathMapStack.get();
        }
        if (localPathMapStack.isEmpty()) {
            return null;
        }
        return localPathMapStack.peek();
    }

    public static void setLocalPathMap(Map<String, String> localPathMap) {
        Stack<Map<String, String>> localPathMapStack = tLocalPathMapStack.get();
        if (localPathMapStack == null) {
            tLocalPathMapStack.remove();
            localPathMapStack = tLocalPathMapStack.get();
        }
        localPathMapStack.push(localPathMap);
    }

    public static void removeLocalPathMap() {
        Stack<Map<String, String>> localPathMapStack = tLocalPathMapStack.get();
        if (localPathMapStack != null && !localPathMapStack.isEmpty()) {
            localPathMapStack.pop();
        }
    }

    public static Object getAttribute(String key) {
        return tAttributes.get().get(key);
    }

    public static void setAttribute(String key, Object value) {
        tAttributes.get().put(key, value);
    }

    public static void removeAttributes() {
        tAttributes.set(new HashMap());
    }

    public static void removeAttribute(String key) {
        tAttributes.get().remove(key);
    }
}

