/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.filters;

import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.VersionedPath;

public class MediaTypeMatcher
extends Filter {
    private String mediaType;

    public MediaTypeMatcher() {
        this(null);
    }

    public MediaTypeMatcher(String mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public int hashCode() {
        return this.getEqualsComparator().hashCode();
    }

    private String getEqualsComparator() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("|");
        sb.append(this.mediaType);
        sb.append("|");
        sb.append(this.invert);
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof MediaTypeMatcher) {
            MediaTypeMatcher otherMediaTypeMatcher = (MediaTypeMatcher)other;
            return this.getEqualsComparator().equals(otherMediaTypeMatcher.getEqualsComparator());
        }
        return false;
    }

    @Override
    public boolean handleGet(RequestContext requestContext) throws RegistryException {
        String mType;
        VersionedPath versionedPath;
        ResourcePath resourcePath = requestContext.getResourcePath();
        if (resourcePath.parameterExists("new")) {
            String mediaType = resourcePath.getParameterValue("mediaType");
            return mediaType != null && this.invert != this.mediaType.equals(mediaType);
        }
        Resource resource = requestContext.getResource();
        if (resource == null && (versionedPath = RegistryUtils.getVersionedPath(requestContext.getResourcePath())).getVersion() == -1L) {
            resource = requestContext.getRepository().get(requestContext.getResourcePath().getPath());
            requestContext.setResource(resource);
        }
        return resource != null && (mType = resource.getMediaType()) != null && this.invert != mType.equals(this.mediaType);
    }

    @Override
    public boolean handlePut(RequestContext requestContext) throws RegistryException {
        Resource resource = requestContext.getResource();
        if (resource == null) {
            return false;
        }
        String mType = resource.getMediaType();
        return mType != null && this.invert != mType.equals(this.mediaType);
    }

    @Override
    public boolean handleImportResource(RequestContext requestContext) throws RegistryException {
        Resource resource = requestContext.getResource();
        if (resource == null) {
            return false;
        }
        String mType = resource.getMediaType();
        return mType != null && this.invert != mType.equals(this.mediaType);
    }

    @Override
    public boolean handleDelete(RequestContext requestContext) throws RegistryException {
        String mType;
        Resource resource = requestContext.getResource();
        if (resource == null) {
            resource = requestContext.getRepository().get(requestContext.getResourcePath().getPath());
            requestContext.setResource(resource);
        }
        return resource != null && (mType = resource.getMediaType()) != null && this.invert != mType.equals(this.mediaType);
    }

    @Override
    public boolean handleRemoveLink(RequestContext requestContext) throws RegistryException {
        return this.handleDelete(requestContext);
    }

    @Override
    public boolean handleCreateLink(RequestContext requestContext) throws RegistryException {
        return this.handleDelete(requestContext);
    }

    @Override
    public boolean handleCopy(RequestContext requestContext) throws RegistryException {
        String mType;
        Resource resource = requestContext.getRepository().get(requestContext.getSourcePath());
        requestContext.setResource(resource);
        return resource != null && (mType = resource.getMediaType()) != null && this.invert != mType.equals(this.mediaType);
    }

    @Override
    public boolean handleMove(RequestContext requestContext) throws RegistryException {
        return this.handleCopy(requestContext);
    }

    @Override
    public boolean handleRename(RequestContext requestContext) throws RegistryException {
        return this.handleCopy(requestContext);
    }

    @Override
    public boolean handleInvokeAspect(RequestContext requestContext) throws RegistryException {
        String mType;
        Resource resource = requestContext.getResource();
        if (resource == null) {
            resource = requestContext.getRepository().get(requestContext.getResourcePath().getPath());
            requestContext.setResource(resource);
        }
        return resource != null && (mType = resource.getMediaType()) != null && this.invert != mType.equals(this.mediaType);
    }

    @Override
    public boolean handlePutChild(RequestContext requestContext) throws RegistryException {
        String parentMediaType;
        Collection parentCollection = requestContext.getParentCollection();
        if (parentCollection == null) {
            Resource parentResource;
            VersionedPath versionedPath;
            String parentPath = requestContext.getParentPath();
            if (parentPath == null) {
                parentPath = RegistryUtils.getParentPath(requestContext.getResourcePath().getPath());
                requestContext.setParentPath(parentPath);
            }
            if ((versionedPath = RegistryUtils.getVersionedPath(requestContext.getResourcePath())).getVersion() == -1L && (parentResource = requestContext.getRepository().get(parentPath)) != null) {
                if (parentResource instanceof Collection) {
                    parentCollection = (Collection)parentResource;
                    requestContext.setParentCollection(parentCollection);
                } else {
                    String msg = "There already exist non collection resource." + parentPath + "Child can only be added to collections";
                    throw new RegistryException(msg);
                }
            }
        }
        return parentCollection != null && (parentMediaType = parentCollection.getMediaType()) != null && this.invert != parentMediaType.equals(this.mediaType);
    }

    @Override
    public boolean handleImportChild(RequestContext requestContext) throws RegistryException {
        String parentMediaType;
        Collection parentCollection = requestContext.getParentCollection();
        if (parentCollection == null) {
            VersionedPath versionedPath;
            String parentPath = requestContext.getParentPath();
            if (parentPath == null) {
                parentPath = RegistryUtils.getParentPath(requestContext.getResourcePath().getPath());
                requestContext.setParentPath(parentPath);
            }
            if ((versionedPath = RegistryUtils.getVersionedPath(requestContext.getResourcePath())).getVersion() == -1L) {
                parentCollection = (Collection)requestContext.getRepository().get(parentPath);
                requestContext.setParentCollection(parentCollection);
            }
        }
        return parentCollection != null && (parentMediaType = parentCollection.getMediaType()) != null && this.invert != parentMediaType.equals(this.mediaType);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }
}

