/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.EditProcessor;
import org.wso2.carbon.registry.core.jdbc.handlers.TextEditProcessor;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class CustomEditManager {
    private static Log log = LogFactory.getLog(CustomEditManager.class);
    private Map<String, EditProcessor> editProcessors = new HashMap<String, EditProcessor>();

    public CustomEditManager() {
        this.editProcessors.put("system.text.edit.processor", new TextEditProcessor());
    }

    public void addProcessor(String processorKey, EditProcessor editProcessor) {
        this.editProcessors.put(processorKey, editProcessor);
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws RegistryException {
        String processorKey = request.getParameter("edit-processor");
        if (processorKey == null) {
            String msg = "Processor key is not set in the request, which is generated by a custom edit UI.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        EditProcessor editProcessor = this.editProcessors.get(processorKey);
        if (editProcessor == null) {
            String msg = "Edit processor is not registered for processing the custom edit requests for key " + processorKey;
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String viewType = request.getParameter("view-type");
        if (viewType == null || "".equals(viewType)) {
            String msg = "View type is not specified in the custom UI edit/new request. Requests made from custom UIs should contain 'view-type' parameter with value set to 'edit' or 'new'";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        String viewKey = request.getParameter("view-key");
        String path = "/";
        boolean responseSent = false;
        if ("edit".equals(viewType)) {
            path = request.getParameter("resourcePath");
            responseSent = editProcessor.processEditContent(path, viewKey, request, response);
        } else if ("new".equals(viewType)) {
            path = request.getParameter("parentPath");
            responseSent = editProcessor.processNewContent(path, viewKey, request, response);
        }
        if (!responseSent) {
            String redirectURL = request.getParameter("redirectURL");
            if (redirectURL != null) {
                RegistryUtils.redirect(response, redirectURL);
            } else {
                ResourcePath resourcePath = new ResourcePath(path);
                RegistryUtils.redirect(response, "/wso2registry/web" + resourcePath.getPathWithVersion());
            }
        }
    }
}

