/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.cli;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.ExitException;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public abstract class CommonCommands
implements Commands {
    protected String defaultIndent = "";
    public static final String INDENT = "  ";
    BufferedReader bufferedReader;
    public String placeHolder = "-";

    public BufferedReader getBufferedReader() {
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.bufferedReader;
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    protected String readline() {
        try {
            String x = this.getBufferedReader().readLine();
            if (x.equals("/exit")) {
                throw new ExitException("/exit encountered");
            }
            return x;
        }
        catch (IOException iox) {
            throw new GeneralException("Error, could not read the input line due to IOException", (Throwable)iox);
        }
    }

    protected void say(String x) {
        System.out.println(this.defaultIndent + x);
    }

    protected void sayi(String x) {
        this.say(INDENT + x);
    }

    protected void say2(String x) {
        System.out.print(this.defaultIndent + x);
    }

    protected void sayi2(String x) {
        this.say2(INDENT + x);
    }

    protected boolean showHelp(InputLine inputLine) {
        return 1 < inputLine.size() && inputLine.getArg(1).equals("--help");
    }

    protected boolean isOk(String x) {
        if (x == null || x.length() == 0) {
            return false;
        }
        return x.trim().toLowerCase().equals("y");
    }

    protected String getInput(String prompt, String defaultValue) {
        this.sayi2(prompt + "[" + (defaultValue == null ? "(null)" : defaultValue) + "]:");
        String inLine = this.readline();
        if (this.isEmpty(inLine)) {
            return defaultValue;
        }
        return inLine;
    }

    protected boolean isEmpty(String x) {
        return x == null || x.length() == 0;
    }

    public String getPlaceHolder() {
        return this.placeHolder;
    }

    public void setPlaceHolder(String placeHolder) {
        this.placeHolder = placeHolder;
    }

    protected String getValue(String x) {
        return this.isEmpty(x) ? this.getPlaceHolder() : x;
    }
}

