/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;

public class TenantAwarePatternLayout
extends PatternLayout {
    public static final String DEFAULT_TENANT_PATTERN = "[%T][%S]";
    private static String tenantPattern = "[%T][%S]";
    private static String superTenantText = null;

    public TenantAwarePatternLayout() {
    }

    public TenantAwarePatternLayout(String pattern) {
        super(pattern);
    }

    protected PatternParser createPatternParser(String pattern) {
        return new TenantAwarePatternParser(pattern);
    }

    public synchronized void setTenantPattern(String tenantPattern) {
        TenantAwarePatternLayout.tenantPattern = tenantPattern;
    }

    public static void setSuperTenantText(String superTenantText) {
        TenantAwarePatternLayout.superTenantText = superTenantText;
    }

    private static class TenantAwarePatternParser
    extends PatternParser {
        CarbonContext carbonContext = CarbonContext.getThreadLocalCarbonContext();
        int tenantId = this.carbonContext.getTenantId();
        InetAddress inetAddress;
        String address;
        String serverName = ServerConfiguration.getInstance().getFirstProperty("ServerKey");

        public TenantAwarePatternParser(String pattern) {
            super(pattern);
            try {
                this.inetAddress = InetAddress.getLocalHost();
                this.address = this.inetAddress.getHostAddress();
            }
            catch (UnknownHostException e) {
                this.address = "127.0.0.1";
            }
        }

        protected void finalizeConverter(char c) {
            TenantAwareNamedPatternConverter pc = null;
            switch (c) {
                case 'D': {
                    pc = new TenantDomainPatternConverter(this.formattingInfo, this.extractPrecisionOption(), this.carbonContext);
                    break;
                }
                case '@': {
                    pc = new AtSignPatternConverter(this.formattingInfo);
                    break;
                }
                case 'P': {
                    pc = new TenantPatternConverter(this.formattingInfo, this.extractPrecisionOption(), this.tenantId);
                    break;
                }
                case 'T': {
                    pc = new TenantIdPatternConverter(this.formattingInfo, this.extractPrecisionOption(), this.tenantId);
                    break;
                }
                case 'S': {
                    pc = new ServiceNamePatternConverter(this.formattingInfo, this.extractPrecisionOption(), this.serverName);
                    break;
                }
                case 'U': {
                    pc = new UserNamePatternConverter(this.formattingInfo, this.extractPrecisionOption(), this.carbonContext);
                    break;
                }
                case 'A': {
                    pc = new AppNamePatternConverter(this.formattingInfo, this.extractPrecisionOption(), this.carbonContext);
                    break;
                }
                case 'H': {
                    pc = new HostNamePatternConverter(this.formattingInfo, this.extractPrecisionOption(), this.address);
                    break;
                }
                case 'I': {
                    pc = new InstanceIdPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                default: {
                    super.finalizeConverter(c);
                }
            }
            if (pc != null) {
                this.currentLiteral.setLength(0);
                this.addConverter(pc);
            }
        }

        private static class TenantPatternConverter
        extends TenantAwareNamedPatternConverter {
            int tenantId;

            public TenantPatternConverter(FormattingInfo formattingInfo, int precision, int tenantId1) {
                super(formattingInfo, precision);
                this.tenantId = tenantId1;
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (this.tenantId != -1 && this.tenantId != -1234) {
                    return new TenantAwarePatternLayout(tenantPattern).format(event);
                }
                return superTenantText;
            }
        }

        private static class AtSignPatternConverter
        extends TenantAwareNamedPatternConverter {
            public AtSignPatternConverter(FormattingInfo formattingInfo) {
                super(formattingInfo, -1);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (CarbonContext.getCurrentContext().getTenantDomain() != null) {
                    return "@";
                }
                return null;
            }
        }

        private static class AppNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            CarbonContext context;

            public AppNamePatternConverter(FormattingInfo formattingInfo, int precision, CarbonContext carbonContext1) {
                super(formattingInfo, precision);
                this.context = carbonContext1;
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (event instanceof TenantAwareLoggingEvent) {
                    if (((TenantAwareLoggingEvent)event).getServiceName() != null) {
                        return ((TenantAwareLoggingEvent)event).getServiceName();
                    }
                    return "";
                }
                String temp = this.context.getApplicationName();
                if (temp != null) {
                    return temp;
                }
                return "";
            }
        }

        private static class InstanceIdPatternConverter
        extends TenantAwareNamedPatternConverter {
            public InstanceIdPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                String stratosInstance = System.getProperty("carbon.instance.name");
                if (stratosInstance != null) {
                    return stratosInstance;
                }
                return "";
            }
        }

        private static class HostNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            String address;

            public HostNamePatternConverter(FormattingInfo formattingInfo, int precision, String address1) {
                super(formattingInfo, precision);
                this.address = address1;
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return this.address;
            }
        }

        private static class ServiceNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            String serverName;

            public ServiceNamePatternConverter(FormattingInfo formattingInfo, int precision, String serverName1) {
                super(formattingInfo, precision);
                this.serverName = serverName1;
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return this.serverName;
            }
        }

        private static class TenantDomainPatternConverter
        extends TenantAwareNamedPatternConverter {
            CarbonContext carbonContext;

            public TenantDomainPatternConverter(FormattingInfo formattingInfo, int precision, CarbonContext carbonContext1) {
                super(formattingInfo, precision);
                this.carbonContext = carbonContext1;
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return this.carbonContext.getTenantDomain();
            }
        }

        private static class UserNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            CarbonContext carbonContext;

            public UserNamePatternConverter(FormattingInfo formattingInfo, int precision, CarbonContext carbonContext1) {
                super(formattingInfo, precision);
                this.carbonContext = carbonContext1;
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return this.carbonContext.getUsername();
            }
        }

        private static class TenantIdPatternConverter
        extends TenantAwareNamedPatternConverter {
            int tenantId;

            public TenantIdPatternConverter(FormattingInfo formattingInfo, int precision, int tenantId) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (event instanceof TenantAwareLoggingEvent) {
                    return ((TenantAwareLoggingEvent)event).getTenantId();
                }
                if (this.tenantId != -1) {
                    return Integer.toString(this.tenantId);
                }
                return null;
            }
        }

        private static abstract class TenantAwareNamedPatternConverter
        extends PatternConverter {
            private int precision;

            public TenantAwareNamedPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo);
                this.precision = precision;
            }

            protected abstract String getFullyQualifiedName(LoggingEvent var1);

            public String convert(LoggingEvent event) {
                String n = this.getFullyQualifiedName(event);
                if (n == null) {
                    return "";
                }
                if (this.precision <= 0) {
                    return n;
                }
                int len = n.length();
                int end = len - 1;
                for (int i = this.precision; i > 0; --i) {
                    if ((end = n.lastIndexOf(46, end - 1)) != -1) continue;
                    return n;
                }
                return n.substring(end + 1, len);
            }
        }
    }
}

