/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.util.executor.AbstractExecutorThreadFactory;

public final class SingleExecutorThreadFactory
extends AbstractExecutorThreadFactory {
    private final String threadName;

    public SingleExecutorThreadFactory(ThreadGroup threadGroup, ClassLoader classLoader, String threadName) {
        super(threadGroup, classLoader);
        this.threadName = threadName;
    }

    @Override
    protected Thread createThread(Runnable r) {
        return new ManagedThread(r);
    }

    private class ManagedThread
    extends Thread {
        public ManagedThread(Runnable target) {
            super(SingleExecutorThreadFactory.this.threadGroup, target, SingleExecutorThreadFactory.this.threadName);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
        }
    }
}

