/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.CompareAndRemoveOperation;
import com.hazelcast.queue.client.QueueRequest;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class CompareAndRemoveRequest
extends QueueRequest {
    private Collection<Data> dataList;
    boolean retain;

    public CompareAndRemoveRequest() {
    }

    public CompareAndRemoveRequest(String name, Collection<Data> dataList, boolean retain) {
        super(name);
        this.dataList = dataList;
        this.retain = retain;
    }

    @Override
    protected Operation prepareOperation() {
        return new CompareAndRemoveOperation(this.name, this.dataList, this.retain);
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        super.writePortable(writer);
        writer.writeBoolean("r", this.retain);
        writer.writeInt("s", this.dataList.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Data data : this.dataList) {
            data.writeData(out);
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        super.readPortable(reader);
        this.retain = reader.readBoolean("r");
        int size = reader.readInt("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.dataList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = new Data();
            data.readData(in);
            this.dataList.add(data);
        }
    }
}

