/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.nio.TcpIpConnectionManager;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class SocketAcceptor
implements Runnable {
    private final ServerSocketChannel serverSocketChannel;
    private final TcpIpConnectionManager connectionManager;
    private final ILogger logger;

    public SocketAcceptor(ServerSocketChannel serverSocketChannel, TcpIpConnectionManager connectionManager) {
        this.serverSocketChannel = serverSocketChannel;
        this.connectionManager = connectionManager;
        this.logger = connectionManager.ioService.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block9: {
            Selector selector = null;
            try {
                this.log(Level.FINEST, "Starting SocketAcceptor on " + this.serverSocketChannel);
                selector = Selector.open();
                this.serverSocketChannel.configureBlocking(false);
                this.serverSocketChannel.register(selector, 16);
                while (this.connectionManager.isLive()) {
                    int keyCount = selector.select();
                    if (Thread.currentThread().isInterrupted()) break;
                    if (keyCount == 0) continue;
                    Set<SelectionKey> setSelectedKeys = selector.selectedKeys();
                    Iterator<SelectionKey> it = setSelectedKeys.iterator();
                    while (it.hasNext()) {
                        SelectionKey sk = it.next();
                        it.remove();
                        if (!sk.isValid() || !sk.isAcceptable()) continue;
                        this.acceptSocket();
                    }
                }
                this.closeSelector(selector);
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
            catch (IOException e2) {
                this.log(Level.SEVERE, e2.getClass().getName() + ": " + e2.getMessage(), e2);
                this.closeSelector(selector);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeSelector(selector);
            }
        }
    }

    private void closeSelector(Selector selector) {
        if (selector != null) {
            try {
                this.logger.finest("Closing selector " + Thread.currentThread().getName());
                selector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void acceptSocket() {
        SocketChannel socketChannel;
        if (!this.connectionManager.isLive()) {
            return;
        }
        SocketChannelWrapper socketChannelWrapper = null;
        try {
            socketChannel = this.serverSocketChannel.accept();
            if (socketChannel != null) {
                socketChannelWrapper = this.connectionManager.wrapSocketChannel(socketChannel, false);
            }
        }
        catch (Exception e) {
            if (e instanceof ClosedChannelException && !this.connectionManager.isLive()) {
                this.logger.finest("Terminating socket acceptor thread...", e);
            }
            String error = "Unexpected error while accepting connection! " + e.getClass().getName() + ": " + e.getMessage();
            this.log(Level.WARNING, error);
            try {
                this.serverSocketChannel.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.connectionManager.ioService.onFatalError(e);
        }
        if (socketChannelWrapper != null) {
            socketChannel = socketChannelWrapper;
            this.log(Level.INFO, "Accepting socket connection from " + socketChannel.socket().getRemoteSocketAddress());
            final MemberSocketInterceptor memberSocketInterceptor = this.connectionManager.getMemberSocketInterceptor();
            if (memberSocketInterceptor == null) {
                try {
                    this.initializeSocketChannel((SocketChannelWrapper)((Object)socketChannel));
                }
                catch (Exception e) {
                    this.log(Level.WARNING, e.getClass().getName() + ": " + e.getMessage(), e);
                    IOUtil.closeResource(socketChannel);
                }
            } else {
                this.connectionManager.ioService.executeAsync(new Runnable((SocketChannelWrapper)((Object)socketChannel)){
                    final /* synthetic */ SocketChannelWrapper val$socketChannel;
                    {
                        this.val$socketChannel = socketChannelWrapper;
                    }

                    @Override
                    public void run() {
                        try {
                            SocketAcceptor.this.log(Level.FINEST, "Calling member socket interceptor: " + memberSocketInterceptor + " for " + this.val$socketChannel);
                            memberSocketInterceptor.onAccept(this.val$socketChannel.socket());
                            SocketAcceptor.this.initializeSocketChannel(this.val$socketChannel);
                        }
                        catch (Exception e) {
                            SocketAcceptor.this.log(Level.WARNING, e.getClass().getName() + ": " + e.getMessage(), e);
                            IOUtil.closeResource(this.val$socketChannel);
                        }
                    }
                });
            }
        }
    }

    private void initializeSocketChannel(SocketChannelWrapper socketChannel) throws Exception {
        socketChannel.configureBlocking(false);
        this.connectionManager.initSocket(socketChannel.socket());
        this.connectionManager.assignSocketChannel(socketChannel);
    }

    private void log(Level level, String message) {
        this.log(level, message, null);
    }

    private void log(Level level, String message, Exception e) {
        this.logger.log(level, message, e);
        this.connectionManager.ioService.getSystemLogService().logConnection(message);
    }
}

