/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong.proxy;

import com.hazelcast.concurrent.atomiclong.AddAndGetOperation;
import com.hazelcast.concurrent.atomiclong.AtomicLongService;
import com.hazelcast.concurrent.atomiclong.CompareAndSetOperation;
import com.hazelcast.concurrent.atomiclong.GetAndAddOperation;
import com.hazelcast.concurrent.atomiclong.GetAndSetOperation;
import com.hazelcast.concurrent.atomiclong.SetOperation;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.Future;

public class AtomicLongProxySupport
extends AbstractDistributedObject<AtomicLongService> {
    private final String name;
    private final int partitionId;

    public AtomicLongProxySupport(String name, NodeEngine nodeEngine, AtomicLongService service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(nodeEngine.toData(name));
    }

    public long addAndGetInternal(long delta) {
        try {
            AddAndGetOperation operation = new AddAndGetOperation(this.name, delta);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            Future f = inv.invoke();
            return (Long)f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    public boolean compareAndSetInternal(long expect, long update) {
        try {
            CompareAndSetOperation operation = new CompareAndSetOperation(this.name, expect, update);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            Future f = inv.invoke();
            return (Boolean)f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    public void setInternal(long newValue) {
        try {
            SetOperation operation = new SetOperation(this.name, newValue);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            inv.invoke();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    public long getAndSetInternal(long newValue) {
        try {
            GetAndSetOperation operation = new GetAndSetOperation(this.name, newValue);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            Future f = inv.invoke();
            return (Long)f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    public long getAndAddInternal(long delta) {
        try {
            GetAndAddOperation operation = new GetAndAddOperation(this.name, delta);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            Future f = inv.invoke();
            return (Long)f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public Object getId() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicLongService";
    }
}

