/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.list;

import com.hazelcast.collection.CollectionProxy;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.multimap.MultiMapProxySupport;
import com.hazelcast.collection.operations.CollectionResponse;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.core.IList;
import com.hazelcast.core.ItemListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ObjectListProxy<E>
extends MultiMapProxySupport
implements CollectionProxy,
IList<E> {
    public static final String COLLECTION_LIST_NAME = "hz:list:";
    final Data key;

    public ObjectListProxy(CollectionService service, NodeEngine nodeEngine, CollectionProxyId proxyId) {
        super(service, nodeEngine, ObjectListProxy.createConfig(proxyId), proxyId);
        this.key = nodeEngine.toData(proxyId.getKeyName());
    }

    private static MultiMapConfig createConfig(CollectionProxyId proxyId) {
        return new MultiMapConfig().setName(COLLECTION_LIST_NAME + proxyId.getKeyName()).setValueCollectionType(MultiMapConfig.ValueCollectionType.LIST);
    }

    @Override
    public String getName() {
        return this.proxyId.getKeyName();
    }

    @Override
    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        return ((CollectionService)this.getService()).addListener(this.proxyId.getName(), listener, this.key, includeValue, false);
    }

    @Override
    public boolean removeItemListener(String registrationId) {
        return ((CollectionService)this.getService()).removeListener(this.proxyId.getName(), registrationId);
    }

    @Override
    public int size() {
        return this.countInternal(this.key);
    }

    @Override
    public boolean isEmpty() {
        return this.countInternal(this.key) == 0;
    }

    @Override
    public boolean contains(Object o) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Data data = nodeEngine.toData(o);
        return this.containsInternalList(this.key, data);
    }

    @Override
    public Iterator<E> iterator() {
        NodeEngine nodeEngine = this.getNodeEngine();
        CollectionResponse result = this.getAllInternal(this.key);
        return result.getObjectCollection(nodeEngine).iterator();
    }

    @Override
    public Object[] toArray() {
        NodeEngine nodeEngine = this.getNodeEngine();
        CollectionResponse result = this.getAllInternal(this.key);
        return result.getObjectCollection(nodeEngine).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        NodeEngine nodeEngine = this.getNodeEngine();
        CollectionResponse result = this.getAllInternal(this.key);
        Collection col = result.getObjectCollection(nodeEngine);
        return col.toArray(a);
    }

    @Override
    public boolean add(E e) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Data data = nodeEngine.toData(e);
        return this.putInternal(this.key, data, -1);
    }

    @Override
    public boolean remove(Object o) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Data data = nodeEngine.toData(o);
        return this.removeInternal(this.key, data);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        NodeEngine nodeEngine = this.getNodeEngine();
        HashSet<Data> dataSet = new HashSet<Data>(c.size());
        for (Object o : c) {
            dataSet.add(nodeEngine.toData(o));
        }
        return this.containsAllInternal(this.key, dataSet);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(-1, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addAllInternal(this.key, this.toDataList(c), index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.compareAndRemoveInternal(this.key, this.toDataList(c), false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.compareAndRemoveInternal(this.key, this.toDataList(c), true);
    }

    @Override
    public void clear() {
        this.removeInternal(this.key);
    }

    @Override
    public E get(int index) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Object data = this.getInternal(this.key, index);
        return (E)nodeEngine.toObject(data);
    }

    @Override
    public E set(int index, E element) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Data value = nodeEngine.toData(element);
        Object data = this.setInternal(this.key, index, value);
        return (E)nodeEngine.toObject(data);
    }

    @Override
    public void add(int index, E element) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Data data = nodeEngine.toData(element);
        this.putInternal(this.key, data, index);
    }

    @Override
    public E remove(int index) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Object data = this.removeInternal(this.key, index);
        return (E)nodeEngine.toObject(data);
    }

    @Override
    public int indexOf(Object o) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataValue = nodeEngine.toData(o);
        return this.indexOfInternal(this.key, dataValue, false);
    }

    @Override
    public int lastIndexOf(Object o) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Data dataValue = nodeEngine.toData(o);
        return this.indexOfInternal(this.key, dataValue, true);
    }

    @Override
    public ListIterator<E> listIterator() {
        NodeEngine nodeEngine = this.getNodeEngine();
        CollectionResponse result = this.getAllInternal(this.key);
        List list = (List)result.getObjectCollection(nodeEngine);
        return list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        NodeEngine nodeEngine = this.getNodeEngine();
        CollectionResponse result = this.getAllInternal(this.key);
        List list = (List)result.getObjectCollection(nodeEngine);
        return list.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        NodeEngine nodeEngine = this.getNodeEngine();
        CollectionResponse result = this.getAllInternal(this.key);
        List list = (List)result.getObjectCollection(nodeEngine);
        return list.subList(fromIndex, toIndex);
    }

    @Override
    public Object getId() {
        return this.proxyId;
    }

    private List<Data> toDataList(Collection coll) {
        NodeEngine nodeEngine = this.getNodeEngine();
        ArrayList<Data> dataList = new ArrayList<Data>(coll.size());
        for (Object obj : coll) {
            dataList.add(nodeEngine.toData(obj));
        }
        return dataList;
    }
}

