/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CollectionMigrationOperation
extends AbstractOperation {
    Map<CollectionProxyId, Map> map;

    public CollectionMigrationOperation() {
    }

    public CollectionMigrationOperation(Map<CollectionProxyId, Map> map) {
        this.map = map;
    }

    @Override
    public void run() throws Exception {
        CollectionService service = (CollectionService)this.getService();
        service.insertMigratedData(this.getPartitionId(), this.map);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry<CollectionProxyId, Map> entry : this.map.entrySet()) {
            CollectionProxyId proxyId = entry.getKey();
            proxyId.writeData(out);
            Map collections = entry.getValue();
            out.writeInt(collections.size());
            for (Map.Entry collectionEntry : collections.entrySet()) {
                Data key = (Data)collectionEntry.getKey();
                key.writeData(out);
                CollectionWrapper wrapper = (CollectionWrapper)collectionEntry.getValue();
                Collection<CollectionRecord> coll = wrapper.getCollection();
                out.writeInt(coll.size());
                for (CollectionRecord record : coll) {
                    record.writeData(out);
                }
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int mapSize = in.readInt();
        this.map = new HashMap<CollectionProxyId, Map>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            CollectionProxyId proxyId = new CollectionProxyId();
            proxyId.readData(in);
            int collectionSize = in.readInt();
            HashMap<Data, CollectionWrapper> collections = new HashMap<Data, CollectionWrapper>();
            for (int j = 0; j < collectionSize; ++j) {
                Data key = new Data();
                key.readData(in);
                int collSize = in.readInt();
                ArrayList<CollectionRecord> coll = new ArrayList<CollectionRecord>(collSize);
                for (int k = 0; k < collSize; ++k) {
                    CollectionRecord record = new CollectionRecord();
                    record.readData(in);
                    coll.add(record);
                }
                collections.put(key, new CollectionWrapper(coll));
            }
            this.map.put(proxyId, collections);
        }
    }
}

