/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class CollectionEvent
implements DataSerializable {
    CollectionProxyId proxyId;
    Data key;
    Data value;
    EntryEventType eventType;
    Address caller;

    public CollectionEvent() {
    }

    public CollectionEvent(CollectionProxyId proxyId, Data key, Data value, EntryEventType eventType, Address caller) {
        this.proxyId = proxyId;
        this.key = key;
        this.value = value;
        this.eventType = eventType;
        this.caller = caller;
    }

    public CollectionProxyId getProxyId() {
        return this.proxyId;
    }

    public Data getValue() {
        return this.value;
    }

    public EntryEventType getEventType() {
        return this.eventType;
    }

    public Address getCaller() {
        return this.caller;
    }

    public Data getKey() {
        return this.key;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.proxyId.writeData(out);
        this.key.writeData(out);
        IOUtil.writeNullableData(out, this.value);
        out.writeInt(this.eventType.getType());
        this.caller.writeData(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.proxyId = new CollectionProxyId();
        this.proxyId.readData(in);
        this.key = IOUtil.readData(in);
        this.value = IOUtil.readNullableData(in);
        this.eventType = EntryEventType.getByType(in.readInt());
        this.caller = new Address();
        this.caller.readData(in);
    }
}

