/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import com.tangosol.net.NamedCache;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.compass.needle.coherence.FileLockKey;

public class DefaultCoherenceLockFactory
extends LockFactory {
    private static final Log log = LogFactory.getLog(DefaultCoherenceLockFactory.class);
    private NamedCache cache;
    private String indexName;

    public DefaultCoherenceLockFactory(NamedCache cache, String indexName) {
        this.cache = cache;
        this.indexName = indexName;
    }

    public void clearLock(String lockName) throws IOException {
        this.cache.unlock((Object)new FileLockKey(this.indexName, lockName));
    }

    public Lock makeLock(String lockName) {
        return new CoherenceLock(lockName);
    }

    public class CoherenceLock
    extends Lock {
        private FileLockKey fileLock;

        public CoherenceLock(String lockName) {
            this.fileLock = new FileLockKey(DefaultCoherenceLockFactory.this.indexName, lockName);
        }

        public boolean isLocked() {
            return false;
        }

        public boolean obtain() throws IOException {
            return DefaultCoherenceLockFactory.this.cache.lock((Object)this.fileLock);
        }

        public boolean obtain(long lockWaitTimeout) throws LockObtainFailedException, IOException {
            return DefaultCoherenceLockFactory.this.cache.lock((Object)this.fileLock, lockWaitTimeout);
        }

        public void release() {
            block2: {
                try {
                    DefaultCoherenceLockFactory.this.cache.unlock((Object)this.fileLock);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block2;
                    log.warn((Object)("Failed to release locke on index [" + DefaultCoherenceLockFactory.this.indexName + "]"), (Throwable)e);
                }
            }
        }
    }
}

