/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.compass.needle.coherence.CoherenceDirectory;
import org.compass.needle.coherence.CoherenceDirectoryException;
import org.compass.needle.coherence.FileBucketKey;
import org.compass.needle.coherence.FileBucketValue;
import org.compass.needle.coherence.FileHeaderKey;
import org.compass.needle.coherence.FileHeaderValue;

class CoherenceIndexInput
extends IndexInput {
    private CoherenceDirectory dir;
    private FileHeaderKey fileHeaderKey;
    private FileHeaderValue fileHeaderValue;
    private long position;
    private FileBucketKey fileBucketKey;
    private FileBucketValue fileBucketValue;
    private int currentBucketPosition;

    public CoherenceIndexInput(CoherenceDirectory dir, FileHeaderKey fileHeaderKey, FileHeaderValue fileHeaderValue) {
        this.dir = dir;
        this.fileHeaderKey = fileHeaderKey;
        this.fileHeaderValue = fileHeaderValue;
        this.fileBucketKey = new FileBucketKey(fileHeaderKey.getIndexName(), fileHeaderKey.getFileName(), -1L);
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.position;
    }

    public long length() {
        return this.fileHeaderValue.getSize();
    }

    public byte readByte() throws IOException {
        this.loadBucketIfNeeded();
        ++this.position;
        return this.fileBucketValue.getData()[this.currentBucketPosition++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.loadBucketIfNeeded();
        if (len <= this.dir.getBucketSize() - this.currentBucketPosition) {
            if (len > 0) {
                System.arraycopy(this.fileBucketValue.getData(), this.currentBucketPosition, b, offset, len);
            }
            this.currentBucketPosition += len;
            this.position += (long)len;
            return;
        }
        while (true) {
            int available;
            int sizeToRead = len <= (available = this.dir.getBucketSize() - this.currentBucketPosition) ? len : available;
            System.arraycopy(this.fileBucketValue.getData(), this.currentBucketPosition, b, offset, sizeToRead);
            offset += sizeToRead;
            this.position += (long)sizeToRead;
            this.currentBucketPosition += sizeToRead;
            if ((len -= sizeToRead) <= 0) break;
            this.loadBucketIfNeeded();
        }
    }

    public void seek(long pos) throws IOException {
        this.position = pos;
    }

    private void loadBucketIfNeeded() throws IOException {
        this.currentBucketPosition = (int)this.position % this.dir.getBucketSize();
        long bucketIndex = this.position / (long)this.dir.getBucketSize();
        if (bucketIndex == this.fileBucketKey.getBucketIndex()) {
            return;
        }
        this.fileBucketKey = new FileBucketKey(this.fileHeaderKey.getIndexName(), this.fileHeaderKey.getFileName(), bucketIndex);
        try {
            this.fileBucketValue = (FileBucketValue)this.dir.getCache().get((Object)this.fileBucketKey);
        }
        catch (Exception e) {
            throw new CoherenceDirectoryException(this.fileBucketKey.getIndexName(), this.fileBucketKey.getFileName(), "Failed to read bucket [" + bucketIndex + "]", e);
        }
        if (this.fileBucketValue == null) {
            throw new CoherenceDirectoryException(this.fileBucketKey.getIndexName(), this.fileBucketKey.getFileName(), "Bucket [" + bucketIndex + "] not found");
        }
    }

    public Object clone() {
        CoherenceIndexInput indexInput = (CoherenceIndexInput)super.clone();
        indexInput.fileBucketKey = new FileBucketKey(this.fileHeaderKey.getIndexName(), this.fileHeaderKey.getFileName(), -1L);
        return indexInput;
    }
}

