/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.AbstractDirectoryStore;
import org.compass.core.lucene.engine.store.CopyFromHolder;
import org.compass.needle.coherence.CoherenceDirectory;

public abstract class AbstractCoherenceDirectoryStore
extends AbstractDirectoryStore
implements CompassConfigurable {
    public static final String BUCKET_SIZE_PROP = "compass.engine.store.coherence.bucketSize";
    public static final String FLUSH_RATE_PROP = "compass.engine.store.coherence.flushRate";
    private String indexName;
    private NamedCache cache;
    private int bucketSize;
    private int flushRate;

    public void configure(CompassSettings settings) throws CompassException {
        String connection = this.findConnection(settings.getSetting("compass.engine.connection"));
        int index = connection.indexOf(58);
        this.indexName = connection.substring(0, index);
        String cacheName = connection.substring(index + 1);
        this.bucketSize = settings.getSettingAsInt(BUCKET_SIZE_PROP, 20480);
        this.flushRate = settings.getSettingAsInt(FLUSH_RATE_PROP, 50);
        this.cache = CacheFactory.getCache((String)cacheName);
    }

    protected abstract String findConnection(String var1);

    protected String getIndexName() {
        return this.indexName;
    }

    protected NamedCache getCache() {
        return this.cache;
    }

    protected int getBucketSize() {
        return this.bucketSize;
    }

    public void deleteIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        this.cleanIndex(dir, subContext, subIndex);
    }

    public void cleanIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        ((CoherenceDirectory)dir).deleteContent();
    }

    public CopyFromHolder beforeCopyFrom(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        ((CoherenceDirectory)dir).deleteContent();
        return new CopyFromHolder();
    }

    public void close() {
        this.cache.release();
    }

    public String suggestedIndexDeletionPolicy() {
        return "expirationtime";
    }
}

