/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.EntityManagerFactory;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.lifecycle.HibernateJpaEntityLifecycleInjector;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.AbstractCollectionEvent;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.impl.SessionFactoryImpl;

public class HibernateJpaEntityCollectionLifecycleInjector
extends HibernateJpaEntityLifecycleInjector {
    private Object eventListener;

    public HibernateJpaEntityCollectionLifecycleInjector() {
    }

    public HibernateJpaEntityCollectionLifecycleInjector(boolean registerPostCommitListeneres) {
        super(registerPostCommitListeneres);
    }

    public void injectLifecycle(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        PostCollectionRecreateEventListener[] tempListeners;
        PostCollectionRecreateEventListener[] listeners;
        super.injectLifecycle(entityManagerFactory, device);
        if (this.registerPostCommitListeneres) {
            return;
        }
        HibernateEntityManagerFactory hibernateEntityManagerFactory = (HibernateEntityManagerFactory)entityManagerFactory;
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)hibernateEntityManagerFactory.getSessionFactory();
        EventListeners eventListeners = sessionFactory.getEventListeners();
        if (this.eventListener instanceof PostCollectionRecreateEventListener) {
            listeners = eventListeners.getPostCollectionRecreateEventListeners();
            tempListeners = new PostCollectionRecreateEventListener[listeners.length + 1];
            System.arraycopy(listeners, 0, tempListeners, 0, listeners.length);
            tempListeners[listeners.length] = (PostCollectionRecreateEventListener)this.eventListener;
            eventListeners.setPostCollectionRecreateEventListeners(tempListeners);
        }
        if (this.eventListener instanceof PostCollectionRemoveEventListener) {
            listeners = eventListeners.getPostCollectionRemoveEventListeners();
            tempListeners = new PostCollectionRemoveEventListener[listeners.length + 1];
            System.arraycopy(listeners, 0, tempListeners, 0, listeners.length);
            tempListeners[listeners.length] = (PostCollectionRemoveEventListener)this.eventListener;
            eventListeners.setPostCollectionRemoveEventListeners((PostCollectionRemoveEventListener[])tempListeners);
        }
        if (this.eventListener instanceof PostCollectionUpdateEventListener) {
            listeners = eventListeners.getPostCollectionUpdateEventListeners();
            tempListeners = new PostCollectionUpdateEventListener[listeners.length + 1];
            System.arraycopy(listeners, 0, tempListeners, 0, listeners.length);
            tempListeners[listeners.length] = (PostCollectionUpdateEventListener)this.eventListener;
            eventListeners.setPostCollectionUpdateEventListeners((PostCollectionUpdateEventListener[])tempListeners);
        }
    }

    public void removeLifecycle(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        super.removeLifecycle(entityManagerFactory, device);
        if (this.registerPostCommitListeneres) {
            return;
        }
        HibernateEntityManagerFactory hibernateEntityManagerFactory = (HibernateEntityManagerFactory)entityManagerFactory;
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)hibernateEntityManagerFactory.getSessionFactory();
        EventListeners eventListeners = sessionFactory.getEventListeners();
        PostCollectionRecreateEventListener[] postCollectionRecreateEventListeners = eventListeners.getPostCollectionRecreateEventListeners();
        ArrayList<PostCollectionRecreateEventListener> tempPostCollectionRecreateEventListeners = new ArrayList<PostCollectionRecreateEventListener>();
        for (PostCollectionRecreateEventListener postCollectionRecreateEventListener : postCollectionRecreateEventListeners) {
            if (postCollectionRecreateEventListener instanceof HibernateCollectionEventListener) continue;
            tempPostCollectionRecreateEventListeners.add(postCollectionRecreateEventListener);
        }
        eventListeners.setPostCollectionRecreateEventListeners(tempPostCollectionRecreateEventListeners.toArray(new PostCollectionRecreateEventListener[tempPostCollectionRecreateEventListeners.size()]));
        PostCollectionUpdateEventListener[] postCollectionUpdateEventListeners = eventListeners.getPostCollectionUpdateEventListeners();
        ArrayList<PostCollectionUpdateEventListener> tempPostCollectionUpdateEventListeners = new ArrayList<PostCollectionUpdateEventListener>();
        for (PostCollectionUpdateEventListener postCollectionUpdateEventListener : postCollectionUpdateEventListeners) {
            if (postCollectionUpdateEventListener instanceof HibernateCollectionEventListener) continue;
            tempPostCollectionUpdateEventListeners.add(postCollectionUpdateEventListener);
        }
        eventListeners.setPostCollectionUpdateEventListeners(tempPostCollectionUpdateEventListeners.toArray(new PostCollectionUpdateEventListener[tempPostCollectionUpdateEventListeners.size()]));
        PostCollectionRemoveEventListener[] postCollectionRemoveEventListeners = eventListeners.getPostCollectionRemoveEventListeners();
        ArrayList<PostCollectionRemoveEventListener> tempPostCollectionRemoveEventListeners = new ArrayList<PostCollectionRemoveEventListener>();
        for (PostCollectionRemoveEventListener postCollectionRemoveEventListener : postCollectionRemoveEventListeners) {
            if (postCollectionRemoveEventListener instanceof HibernateCollectionEventListener) continue;
            tempPostCollectionRemoveEventListeners.add(postCollectionRemoveEventListener);
        }
        eventListeners.setPostCollectionRemoveEventListeners(tempPostCollectionRemoveEventListeners.toArray(new PostCollectionRemoveEventListener[tempPostCollectionRemoveEventListeners.size()]));
        this.eventListener = null;
    }

    protected Object doCreateListener(JpaGpsDevice device) {
        this.eventListener = new HibernateCollectionEventListener(device);
        return this.eventListener;
    }

    public static class HibernateCollectionEventListener
    extends HibernateJpaEntityLifecycleInjector.HibernateEventListener
    implements PostCollectionRecreateEventListener,
    PostCollectionRemoveEventListener,
    PostCollectionUpdateEventListener {
        public HibernateCollectionEventListener(JpaGpsDevice device) {
            super(device);
        }

        public void onPostRecreateCollection(PostCollectionRecreateEvent postCollectionRecreateEvent) {
            this.processCollectionEvent((AbstractCollectionEvent)postCollectionRecreateEvent);
        }

        public void onPostRemoveCollection(PostCollectionRemoveEvent postCollectionRemoveEvent) {
            this.processCollectionEvent((AbstractCollectionEvent)postCollectionRemoveEvent);
        }

        public void onPostUpdateCollection(PostCollectionUpdateEvent postCollectionUpdateEvent) {
            this.processCollectionEvent((AbstractCollectionEvent)postCollectionUpdateEvent);
        }

        private void processCollectionEvent(AbstractCollectionEvent event) {
            Object entity = event.getAffectedOwnerOrNull();
            if (entity == null) {
                return;
            }
            Serializable id = this.getId(entity, event);
            if (id == null) {
                this.log.warn((Object)("Unable to reindex entity on collection change, id cannot be extracted: " + event.getAffectedOwnerEntityName()));
                return;
            }
            this.postUpdate(entity);
        }

        private Serializable getId(Object entity, AbstractCollectionEvent event) {
            Serializable id = event.getAffectedOwnerIdOrNull();
            if (id == null) {
                EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
                id = entityEntry == null ? null : entityEntry.getId();
            }
            return id;
        }
    }
}

