/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.reader;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.compass.core.util.StringUtils;

public class MultiIOReader
extends Reader {
    private ArrayList readers = new ArrayList();
    private ArrayList names = new ArrayList();
    private Reader currentReader;
    private int index = 0;

    public MultiIOReader() {
    }

    public MultiIOReader(Reader reader) {
        this.add(reader);
    }

    public MultiIOReader(String name, Reader reader) {
        this.add(name, reader);
    }

    public MultiIOReader(Reader[] readers) {
        for (int i = 0; i < readers.length; ++i) {
            this.add(null, readers[i]);
        }
    }

    public MultiIOReader(String[] names, Reader[] readers) {
        for (int i = 0; i < readers.length; ++i) {
            this.add(names[i], readers[i]);
        }
    }

    public void add(Reader reader) {
        this.add(null, reader);
    }

    public void add(String name, Reader reader) {
        if (reader == null) {
            return;
        }
        if (name != null) {
            this.names.add(name);
        }
        this.readers.add(reader);
        if (this.currentReader == null) {
            this.currentReader = reader;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.readers == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        int retVal = -1;
        while (retVal == -1) {
            retVal = this.currentReader.read();
            if (retVal != -1) continue;
            ++this.index;
            if (this.index == this.readers.size()) {
                return -1;
            }
            this.currentReader = (Reader)this.readers.get(this.index);
        }
        return retVal;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        int sizeRead = -1;
        while (sizeRead == -1) {
            sizeRead = this.currentReader.read(cbuf, off, len);
            if (sizeRead != -1) continue;
            ++this.index;
            if (this.index == this.readers.size()) {
                return -1;
            }
            this.currentReader = (Reader)this.readers.get(this.index);
        }
        return sizeRead;
    }

    public void close() throws IOException {
        if (this.readers == null) {
            return;
        }
        IOException ioe = null;
        for (int i = 0; i < this.readers.size(); ++i) {
            try {
                ((Reader)this.readers.get(i)).close();
                continue;
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        this.readers = null;
        if (ioe != null) {
            throw ioe;
        }
    }

    public String toString() {
        return StringUtils.collectionToCommaDelimitedString(this.names);
    }
}

