/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.analyzer;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerTokenFilterProvider;

public class LuceneAnalyzerFilterWrapper
extends Analyzer {
    private Analyzer analyzer;
    private LuceneAnalyzerTokenFilterProvider[] filteresProviders;

    public LuceneAnalyzerFilterWrapper(Analyzer analyzer, LuceneAnalyzerTokenFilterProvider[] filteresProviders) {
        this.analyzer = analyzer;
        this.filteresProviders = filteresProviders;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = this.analyzer.tokenStream(fieldName, reader);
        for (int i = 0; i < this.filteresProviders.length; ++i) {
            result = this.filteresProviders[i].createTokenFilter(result);
        }
        return result;
    }
}

