/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.dynamic;

import org.compass.core.converter.ConversionException;
import org.compass.core.converter.dynamic.ExpressionEvaluator;
import org.compass.core.converter.dynamic.ExpressionEvaluatorFactory;
import org.compass.core.mapping.ResourcePropertyMapping;

public class ThreadSafeExpressionEvaluator
implements ExpressionEvaluator {
    private final int initialPoolSize;
    private final int maxPoolSize;
    private transient ExpressionEvaluator[] pool;
    private int nextAvailable = 0;
    private final Object mutex = new Object();
    private final ExpressionEvaluatorFactory expressionEvaluatorFactory;

    public ThreadSafeExpressionEvaluator(int initialPoolSize, int maxPoolSize, ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.expressionEvaluatorFactory = expressionEvaluatorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Object o, ResourcePropertyMapping resourcePropertyMapping) throws ConversionException {
        ExpressionEvaluator expressionEvaluator = this.fetchFromPool();
        try {
            Object object = expressionEvaluator.evaluate(o, resourcePropertyMapping);
            return object;
        }
        finally {
            this.putInPool(expressionEvaluator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExpressionEvaluator fetchFromPool() {
        ExpressionEvaluator result;
        Object object = this.mutex;
        synchronized (object) {
            if (this.pool == null) {
                this.nextAvailable = -1;
                this.pool = new ExpressionEvaluator[this.maxPoolSize];
                for (int i = 0; i < this.initialPoolSize; ++i) {
                    this.putInPool(this.expressionEvaluatorFactory.create());
                }
            }
            while (this.nextAvailable < 0) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException e) {
                    throw new ConversionException("Interrupted whilst waiting for a free item in the pool", e);
                }
            }
            result = this.pool[this.nextAvailable];
            --this.nextAvailable;
        }
        if (result == null) {
            result = this.expressionEvaluatorFactory.create();
            this.putInPool(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInPool(ExpressionEvaluator expressionEvaluator) {
        Object object = this.mutex;
        synchronized (object) {
            ++this.nextAvailable;
            this.pool[this.nextAvailable] = expressionEvaluator;
            this.mutex.notify();
        }
    }
}

