/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.compass.core.accessor.PropertyAccessor;
import org.compass.core.accessor.PropertyAccessorFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.MultipleMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.util.ClassUtils;

public class PropertyAccessorMappingProcessor
implements MappingProcessor {
    private PropertyAccessorFactory propertyAccessorFactory;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.propertyAccessorFactory = new PropertyAccessorFactory();
        this.propertyAccessorFactory.configure(settings);
        Iterator rIt = compassMapping.mappingsIt();
        while (rIt.hasNext()) {
            Mapping mapping = (Mapping)rIt.next();
            if (!(mapping instanceof ClassMapping)) continue;
            ClassMapping classMapping = (ClassMapping)mapping;
            classMapping.setConstructor(ClassUtils.getDefaultConstructor(classMapping.getClazz()));
            if (!Modifier.isAbstract(classMapping.getClazz().getModifiers()) && !Modifier.isInterface(classMapping.getClazz().getModifiers()) && classMapping.getConstructor() == null) {
                throw new MappingException("No default constructor defined for class [" + classMapping.getName() + "]");
            }
            if (classMapping.getPolyClass() != null) {
                classMapping.setPolyConstructor(ClassUtils.getDefaultConstructor(classMapping.getPolyClass()));
            }
            Class clazz = classMapping.getClazz();
            if (classMapping.isPoly() && classMapping.getPolyClass() != null) {
                clazz = classMapping.getPolyClass();
            }
            Iterator it = classMapping.mappingsIt();
            while (it.hasNext()) {
                this.processMapping((Mapping)it.next(), clazz, settings);
            }
        }
        return compassMapping;
    }

    private void processMapping(Mapping mapping, Class clazz, CompassSettings settings) throws MappingException {
        if (!(mapping instanceof ObjectMapping)) {
            return;
        }
        ObjectMapping objectMapping = (ObjectMapping)mapping;
        PropertyAccessor pAccessor = this.propertyAccessorFactory.getPropertyAccessor(objectMapping.getAccessor(), settings);
        objectMapping.setGetter(pAccessor.getGetter(clazz, objectMapping.getPropertyName()));
        objectMapping.setSetter(pAccessor.getSetter(clazz, objectMapping.getPropertyName()));
        if (mapping instanceof MultipleMapping) {
            MultipleMapping multipleMapping = (MultipleMapping)mapping;
            Iterator it = multipleMapping.mappingsIt();
            while (it.hasNext()) {
                this.processMapping((Mapping)it.next(), clazz, settings);
            }
        }
    }
}

