/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index;

import java.io.IOException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.index.JdbcIndexConfigurable;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public class FetchOnOpenJdbcIndexInput
extends IndexInput
implements JdbcIndexConfigurable {
    private int length;
    private int position = 0;
    private byte[] data;

    public void configure(final String name, final JdbcDirectory jdbcDirectory, JdbcFileEntrySettings settings) throws IOException {
        jdbcDirectory.getJdbcTemplate().executeSelect(jdbcDirectory.getTable().sqlSelectSizeValueByName(), new JdbcTemplate.ExecuteSelectCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, name);
            }

            public Object execute(ResultSet rs) throws Exception {
                if (!rs.next()) {
                    throw new JdbcStoreException("No entry for [" + name + "] table " + jdbcDirectory.getTable());
                }
                FetchOnOpenJdbcIndexInput.this.length = rs.getInt(3);
                Blob blob = rs.getBlob(2);
                FetchOnOpenJdbcIndexInput.access$102(FetchOnOpenJdbcIndexInput.this, blob.getBytes(1L, FetchOnOpenJdbcIndexInput.this.length));
                if (FetchOnOpenJdbcIndexInput.this.data.length != FetchOnOpenJdbcIndexInput.this.length) {
                    throw new IOException("read past EOF");
                }
                return null;
            }
        });
    }

    public byte readByte() throws IOException {
        return this.data[this.position++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        System.arraycopy(this.data, this.position, b, offset, len);
        this.position += len;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.position;
    }

    public void seek(long pos) throws IOException {
        this.position = (int)pos;
    }

    public long length() {
        return this.length;
    }

    static /* synthetic */ byte[] access$102(FetchOnOpenJdbcIndexInput x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }
}

