/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.dialect;

import org.apache.lucene.store.jdbc.dialect.Dialect;

public class OracleDialect
extends Dialect {
    public boolean supportTransactionalScopedBlobs() {
        return true;
    }

    public boolean supportsForUpdate() {
        return true;
    }

    public boolean supportsTableExists() {
        return true;
    }

    public String sqlTableExists(String catalog, String schemaName) {
        if (schemaName == null) {
            return "select table_name from user_tables where lower(table_name) = ?";
        }
        return "select table_name from all_tables where lower(owner) = '" + schemaName.toLowerCase() + "' and lower(table_name) = ?";
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select systimestamp from dual";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getVarcharType(int length) {
        return "varchar2(" + length + " char)";
    }

    public String getBlobType(long length) {
        return "blob";
    }

    public String getNumberType() {
        return "number(10,0)";
    }

    public String getTimestampType() {
        return "timestamp";
    }

    public String getCurrentTimestampFunction() {
        return "current_timestamp";
    }

    public String getBitType() {
        return "number(1,0)";
    }
}

