/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core.stats;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.airavata.messaging.core.stats.CountWriterTask;
import org.apache.airavata.messaging.core.stats.LatencyWriterTask;
import org.apache.airavata.model.messaging.event.Message;

public class StatCounter {
    private static StatCounter ourInstance = new StatCounter();
    private long msgCount;
    private long period = 10000L;
    private long msgCountForPeriod;
    private long bucketStartTime = 0L;
    private File file1;
    private File file2;
    private List<Long> messageContPer10S = new ArrayList<Long>();
    private Map<String, Long> messageTimeStamp = new HashMap<String, Long>();

    public static StatCounter getInstance() {
        return ourInstance;
    }

    public long getMsgCount() {
        return this.msgCount;
    }

    public void setMsgCount(long msgCount) {
        this.msgCount = msgCount;
    }

    public List<Long> getMessageContPer10S() {
        return this.messageContPer10S;
    }

    public void setMessageContPer10S(List<Long> messageContPer10S) {
        this.messageContPer10S = messageContPer10S;
    }

    private StatCounter() {
        this.file1 = new File("/tmp/results");
        this.file2 = new File("/tmp/latency");
        Timer counterTimer = new Timer();
        Timer latencyTimer = new Timer();
        CountWriterTask writerTask = new CountWriterTask();
        writerTask.setFile(this.file1);
        LatencyWriterTask latencyWriterTask = new LatencyWriterTask();
        latencyWriterTask.setFile(this.file2);
        counterTimer.scheduleAtFixedRate((TimerTask)writerTask, 0L, 60000L);
        latencyTimer.scheduleAtFixedRate((TimerTask)latencyWriterTask, 0L, 60000L);
    }

    public void add(Message message) {
        this.messageTimeStamp.put(message.getMessageId(), System.currentTimeMillis());
        if (System.currentTimeMillis() - this.bucketStartTime < this.period) {
            ++this.msgCountForPeriod;
        } else {
            this.messageContPer10S.add(this.msgCountForPeriod);
            this.bucketStartTime = System.currentTimeMillis();
            this.msgCountForPeriod = 1L;
        }
        ++this.msgCount;
    }

    public long getMsgCountForPeriod() {
        return this.msgCountForPeriod;
    }

    public void setMsgCountForPeriod(long msgCountForPeriod) {
        this.msgCountForPeriod = msgCountForPeriod;
    }

    public Map<String, Long> getMessageTimeStamp() {
        return this.messageTimeStamp;
    }

    public void setMessageTimeStamp(Map<String, Long> messageTimeStamp) {
        this.messageTimeStamp = messageTimeStamp;
    }
}

