/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.task.Task;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.DataStagingTaskModel;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStageTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(DataStageTask.class);

    public void init(Map<String, String> propertyMap) throws TaskException {
    }

    public TaskStatus execute(TaskContext taskContext) {
        TaskStatus status = new TaskStatus(TaskState.COMPLETED);
        if (taskContext.getTaskModel().getTaskType() != TaskTypes.DATA_STAGING) {
            status.setState(TaskState.FAILED);
            status.setReason("Invalid task call, expected " + TaskTypes.DATA_STAGING.toString() + " but found " + taskContext.getTaskModel().getTaskType().toString());
        } else {
            try {
                DataStagingTaskModel subTaskModel = (DataStagingTaskModel)taskContext.getSubTaskModel();
                URI sourceURI = new URI(subTaskModel.getSource());
                URI destinationURI = new URI(subTaskModel.getDestination());
                ProcessState processState = taskContext.getParentProcessContext().getProcessState();
                if (processState == ProcessState.INPUT_DATA_STAGING) {
                    taskContext.getParentProcessContext().getDataMovementRemoteCluster().copyTo(sourceURI.getPath(), destinationURI.getPath());
                } else if (processState == ProcessState.OUTPUT_DATA_STAGING) {
                    taskContext.getParentProcessContext().getDataMovementRemoteCluster().copyFrom(sourceURI.getPath(), destinationURI.getPath());
                }
                status.setReason("Successfully staged data");
            }
            catch (GFacException e) {
                String msg = "Scp attempt failed";
                log.error(msg, (Throwable)e);
                status.setState(TaskState.FAILED);
                status.setReason(msg);
                ErrorModel errorModel = new ErrorModel();
                errorModel.setActualErrorMessage(e.getMessage());
                errorModel.setUserFriendlyMessage(msg);
                taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
            }
            catch (TException e) {
                String msg = "Invalid task invocation";
                log.error(msg, (Throwable)e);
                status.setState(TaskState.FAILED);
                status.setReason(msg);
                ErrorModel errorModel = new ErrorModel();
                errorModel.setActualErrorMessage(e.getMessage());
                errorModel.setUserFriendlyMessage(msg);
                taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
            }
            catch (URISyntaxException e) {
                String msg = "source or destination is not a valid URI";
                log.error(msg, (Throwable)e);
                status.setState(TaskState.FAILED);
                status.setReason(msg);
                ErrorModel errorModel = new ErrorModel();
                errorModel.setActualErrorMessage(e.getMessage());
                errorModel.setUserFriendlyMessage(msg);
                taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
            }
        }
        return status;
    }

    public TaskStatus recover(TaskContext taskContext) {
        TaskState state = taskContext.getTaskStatus().getState();
        if (state == TaskState.EXECUTING || state == TaskState.CREATED) {
            return this.execute(taskContext);
        }
        return taskContext.getTaskStatus();
    }

    public TaskTypes getType() {
        return TaskTypes.DATA_STAGING;
    }
}

