/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ns.AbstractEuGridPmaNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EuGridPmaNamespacesStore
extends AbstractEuGridPmaNamespacesStore {
    private Map<String, Map<String, List<NamespacePolicy>>> policiesByHash2 = new HashMap<String, Map<String, List<NamespacePolicy>>>();
    private Map<String, Map<String, List<NamespacePolicy>>> policiesByName = new HashMap<String, Map<String, List<NamespacePolicy>>>();

    public EuGridPmaNamespacesStore(ObserversHandler observers, boolean openssl1Mode) {
        super(observers, openssl1Mode);
    }

    @Override
    public void setPolicies(Collection<String> locations) {
        ArrayList<NamespacePolicy> policies = new ArrayList<NamespacePolicy>();
        for (String location : locations) {
            this.tryLoadNsLocation(location, policies);
        }
        this.setPolicies((List<NamespacePolicy>)policies);
    }

    protected synchronized void setPolicies(List<NamespacePolicy> policies) {
        this.policiesByName = new HashMap<String, Map<String, List<NamespacePolicy>>>(policies.size());
        this.policiesByHash2 = new HashMap<String, Map<String, List<NamespacePolicy>>>();
        for (NamespacePolicy policy : policies) {
            if (policy.getIssuer().contains("=")) {
                this.addPolicy(policy, this.policiesByName);
                continue;
            }
            this.addPolicy(policy, this.policiesByHash2);
        }
    }

    @Override
    protected List<NamespacePolicy> getPoliciesByIssuerHash(String definedForHash, String issuerHash) {
        Map<String, List<NamespacePolicy>> policiesMap = this.policiesByHash2.get(definedForHash);
        if (policiesMap == null) {
            return null;
        }
        return policiesMap.get(issuerHash);
    }

    @Override
    protected List<NamespacePolicy> getPoliciesByIssuerDn(String definedForHash, String issuerDn) {
        Map<String, List<NamespacePolicy>> policiesMap = this.policiesByName.get(definedForHash);
        if (policiesMap == null) {
            return null;
        }
        return policiesMap.get(issuerDn);
    }
}

