/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class PropertyGroupHelper {
    private final Map properties;
    private final String[] acceptedPatterns;
    private final boolean isRegexp;
    private final Pattern[] patterns;

    public PropertyGroupHelper(Map properties, String ... patterns) {
        this(properties, false, patterns);
    }

    public PropertyGroupHelper(Map properties, boolean isRegexp, String ... patterns) {
        this.properties = properties;
        this.acceptedPatterns = patterns;
        this.isRegexp = isRegexp;
        this.patterns = isRegexp ? this.createPatterns() : null;
    }

    public Iterator<String> keys() {
        final Iterator backing = this.properties.keySet().iterator();
        return new Iterator<String>(){
            private String next = null;

            boolean filter(String key) {
                if (PropertyGroupHelper.this.isRegexp) {
                    return PropertyGroupHelper.this.filterRegexp(key);
                }
                return PropertyGroupHelper.this.filterPlain(key);
            }

            @Override
            public boolean hasNext() {
                return this.getNextMatching() != null;
            }

            private String getNextMatching() {
                if (this.next != null) {
                    return this.next;
                }
                if (!backing.hasNext()) {
                    this.next = null;
                    return null;
                }
                String res = (String)backing.next();
                if (res == null) {
                    this.next = null;
                    return null;
                }
                if (!this.filter(res)) {
                    return this.getNextMatching();
                }
                this.next = res;
                return res;
            }

            @Override
            public String next() {
                String res = this.getNextMatching();
                this.next = null;
                return res;
            }

            @Override
            public void remove() {
                backing.remove();
            }
        };
    }

    private Pattern[] createPatterns() {
        Pattern[] ps = new Pattern[this.acceptedPatterns.length];
        for (int i = 0; i < this.acceptedPatterns.length; ++i) {
            ps[i] = Pattern.compile(this.acceptedPatterns[i]);
        }
        return ps;
    }

    private boolean filterRegexp(String key) {
        for (Pattern p : this.patterns) {
            if (!p.matcher(key).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean filterPlain(String key) {
        for (String p : this.acceptedPatterns) {
            if (!key.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getFilteredMap() {
        return this.getFilteredMap(null);
    }

    public Map<String, String> getFilteredMap(String containedString) {
        HashMap<String, String> props = new HashMap<String, String>();
        Iterator<String> keys = this.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (containedString == null) {
                props.put(key, String.valueOf(this.properties.get(key)));
                continue;
            }
            if (!key.contains(containedString)) continue;
            props.put(key, String.valueOf(this.properties.get(key)));
        }
        return props;
    }
}

