/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.dpc;

import eu.unicore.uftp.dpc.AuthorizationCheck;
import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.dpc.DPCClient;
import eu.unicore.uftp.dpc.NoAuth;
import eu.unicore.uftp.dpc.ProtocolViolationException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class DPCServer {
    private static final Logger logger = Logger.getLogger(DPCServer.class);
    public static final String VER = "DPCServer 1.0";
    private final ServerSocket serverSocket;
    private int timeout = 10000;
    private int authTimeout = 10000;
    private final AuthorizationCheck auth;
    private int port;
    protected static final String[] responses = new String[]{"220 (DPCServer 1.0)", "331 Please specify the password", "230 Login successful", "215 Unix Type: L8"};

    public DPCServer(InetAddress ip, int port, int backlog, AuthorizationCheck auth) throws IOException {
        this.port = port;
        this.serverSocket = new ServerSocket(port, backlog, ip);
        this.auth = auth;
    }

    public Connection accept() throws IOException {
        if (this.timeout > 0) {
            this.serverSocket.setSoTimeout(this.timeout);
        }
        Socket controlSocket = this.serverSocket.accept();
        if (this.authTimeout > 0) {
            controlSocket.setSoTimeout(this.authTimeout);
        }
        return new Connection(controlSocket, this.getFeatures());
    }

    private Socket getNewConnection(Socket controlSocket) throws IOException {
        InetAddress expectedClient = controlSocket.getInetAddress();
        Socket r = null;
        BufferedWriter controlWriter = new BufferedWriter(new OutputStreamWriter(controlSocket.getOutputStream()));
        BufferedReader controlReader = new BufferedReader(new InputStreamReader(controlSocket.getInputStream()));
        String inputLine = controlReader.readLine();
        logger.debug("<-- " + inputLine);
        if (inputLine.equals("PASV")) {
            ServerSocket tmp = new ServerSocket(0);
            int port = tmp.getLocalPort();
            String ip = controlSocket.getLocalAddress().getHostAddress().replace('.', ',');
            String outputLine = "227 Entering Passive Mode (" + ip + "," + port / 256 + "," + port % 256 + ")\r\n";
            controlWriter.write(outputLine);
            controlWriter.flush();
            logger.debug("--> " + outputLine);
            r = tmp.accept();
            InetAddress peer = ((InetSocketAddress)r.getRemoteSocketAddress()).getAddress();
            if (!expectedClient.equals(peer)) {
                throw new IOException("Rejecting unexpected connection from " + peer);
            }
            logger.info("Accepted data connection from " + r.getRemoteSocketAddress());
            tmp.close();
        }
        return r;
    }

    public void close() throws IOException {
        this.serverSocket.close();
        logger.info("Server shut down.");
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public int getPort() {
        return this.port;
    }

    public void setAuthTimeout(int authTimeout) {
        this.authTimeout = authTimeout;
    }

    public String[] getFeatures() {
        return new String[]{"PASV", "RANG STREAM"};
    }

    public static AuthorizationCheck noAuth() {
        return new NoAuth();
    }

    public class Connection {
        private final Socket controlSocket;
        private volatile boolean established = false;
        private Socket[] dataSockets = null;
        private final BufferedWriter controlWriter;
        private final BufferedReader controlReader;
        private final String[] features;

        private Connection(Socket controlSocket, String[] features) throws IOException {
            this.controlSocket = controlSocket;
            this.controlWriter = new BufferedWriter(new OutputStreamWriter(controlSocket.getOutputStream()));
            this.controlReader = new BufferedReader(new InputStreamReader(controlSocket.getInputStream()));
            this.features = features;
        }

        public Object establish() throws AuthorizationFailureException, IOException {
            String request;
            logger.info("Establishing control connection with " + this.controlSocket.getRemoteSocketAddress());
            for (int i = 0; i < responses.length; ++i) {
                this.sendControl(responses[i]);
                request = "";
                if (i >= DPCClient.requests.length || DPCClient.requests[i].equals(request = this.readControl())) continue;
                String err = "'" + request + "' does not comply with protocol.";
                this.sendError(err);
                this.controlSocket.close();
                throw new ProtocolViolationException(err);
            }
            request = this.readControl();
            if (!request.equals("FEAT")) {
                throw new ProtocolViolationException("Expected features request.");
            }
            String featureReply = "211 Features:";
            String indent = "";
            if (this.features.length > 1) {
                featureReply = "211-Features:";
                indent = " ";
            }
            this.sendControl(featureReply);
            for (String s : this.features) {
                this.sendControl(indent + s);
            }
            this.sendControl("211 END");
            Socket authSocket = DPCServer.this.getNewConnection(this.controlSocket);
            if (authSocket == null) {
                String err = "Error opening authorisation connection";
                this.sendError(err);
                this.controlSocket.close();
                throw new ProtocolViolationException(err);
            }
            Object authZresult = DPCServer.this.auth.isAuthorized(authSocket);
            if (authZresult == null) {
                authSocket.close();
                this.controlSocket.close();
                throw new AuthorizationFailureException("Authorization failed (wrong secret?)");
            }
            authSocket.close();
            logger.info("Authorization success.");
            this.established = true;
            return authZresult;
        }

        public Socket[] getDataSockets() {
            return this.dataSockets;
        }

        public Socket[] openDataConnections(int maxParCons) throws IOException {
            String noopResponse;
            if (!this.established) {
                throw new IllegalStateException("Connection is not established.");
            }
            if (this.dataSockets != null) {
                throw new ProtocolViolationException("Cannot open new connections.");
            }
            int numParCons = 0;
            String noopMsg = this.readControl();
            if (noopMsg.split(" ")[0].equals("NOOP")) {
                numParCons = Integer.parseInt(noopMsg.split(" ")[1]);
                noopResponse = "222";
                if (numParCons > maxParCons) {
                    numParCons = maxParCons;
                    noopResponse = "223";
                }
            } else {
                String err = "Expected 'NOOP <n>' instead of '" + noopMsg + "'.";
                this.sendError(err);
                this.controlSocket.close();
                throw new ProtocolViolationException(err);
            }
            noopResponse = noopResponse + " Opening " + numParCons + " data connections";
            this.sendControl(noopResponse);
            this.dataSockets = new Socket[numParCons];
            for (int i = 0; i < numParCons; ++i) {
                this.dataSockets[i] = DPCServer.this.getNewConnection(this.controlSocket);
                if (this.dataSockets[i] != null) continue;
                String err = "Expected PASV";
                this.sendError(err);
                for (int j = 0; j < i - 1; ++j) {
                    this.dataSockets[j].close();
                }
                this.controlSocket.close();
                throw new ProtocolViolationException(err);
            }
            return this.dataSockets;
        }

        public void closeData() throws IOException {
            if (this.dataSockets == null) {
                return;
            }
            for (Socket dataSocket : this.dataSockets) {
                dataSocket.close();
            }
        }

        public void close() throws IOException {
            this.closeData();
            this.controlSocket.close();
            logger.info("Connection was closed.");
        }

        public InetAddress getAddress() {
            return this.controlSocket.getInetAddress();
        }

        public void sendControl(String message) throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug("--> " + message.trim());
            }
            this.controlWriter.write(message + "\r\n");
            this.controlWriter.flush();
        }

        public void sendError(String message) throws IOException {
            this.sendControl("500 " + message);
        }

        public String readControl() throws IOException {
            String res = this.controlReader.readLine();
            if (logger.isDebugEnabled() && res != null) {
                logger.debug("<-- " + res.trim());
            }
            return res;
        }

        public void setControlTimeout(int timeout) throws SocketException {
            this.controlSocket.setSoTimeout(timeout);
        }
    }
}

