/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.client;

import eu.unicore.uftp.client.AbstractUFTPClient;
import eu.unicore.uftp.client.UFTPClient;
import eu.unicore.uftp.client.UFTPSessionClient;
import eu.unicore.uftp.dpc.Utils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class ClientFactory {
    public static AbstractUFTPClient create(String[] args) throws Exception {
        Options options = ClientFactory.createOptions();
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("S")) {
                return UFTPSessionClient.create(args);
            }
            return UFTPClient.create(args);
        }
        catch (ParseException pe) {
            System.out.println("Unable to parse client parameters " + pe.getLocalizedMessage());
            System.exit(1);
            return null;
        }
    }

    public static boolean isSend(CommandLine line) {
        boolean send = true;
        if (line.hasOption("s")) {
            send = true;
        } else if (line.hasOption("r")) {
            send = false;
        }
        return send;
    }

    public static void configureClient(AbstractUFTPClient client, CommandLine line, Logger logger) {
        String bufSize;
        int numcons = Integer.parseInt(line.getOptionValue("n"));
        client.setNumConnections(numcons);
        client.setSecret(line.getOptionValue("x"));
        String keyBase64 = line.getOptionValue("E");
        if (keyBase64 != null) {
            client.setKey(Utils.decodeBase64(keyBase64));
        }
        if ((bufSize = line.getOptionValue("b")) != null) {
            client.setBufferSize(Integer.parseInt(bufSize) * 1024);
        }
    }

    public static InetAddress[] getServers(CommandLine line, Logger logger) {
        String[] servers;
        ArrayList<InetAddress> serverList = new ArrayList<InetAddress>();
        for (String s : servers = line.getOptionValue("l").split("[ ,]+")) {
            try {
                InetAddress a = InetAddress.getByName(s);
                serverList.add(a);
            }
            catch (UnknownHostException uhe) {
                logger.debug("No such host: " + s);
            }
        }
        return serverList.toArray(new InetAddress[serverList.size()]);
    }

    public static Options createOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"startSession");
        OptionBuilder.withDescription((String)"Connect to a UFTP session");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"S"));
        OptionBuilder.withLongOpt((String)"commandFile");
        OptionBuilder.withDescription((String)"(Session mode only) Commands file name");
        OptionBuilder.withArgName((String)"Cmdfile");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"send");
        OptionBuilder.withDescription((String)"Send data");
        OptionBuilder.withArgName((String)"Send");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"receive");
        OptionBuilder.withDescription((String)"Receive data");
        OptionBuilder.withArgName((String)"Receive");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"listen-host");
        OptionBuilder.withDescription((String)"Hostname of the server socket");
        OptionBuilder.withArgName((String)"Server host");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"listen-port");
        OptionBuilder.withDescription((String)"Port of the server socket");
        OptionBuilder.withArgName((String)"Server port");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"L"));
        OptionBuilder.withLongOpt((String)"secret");
        OptionBuilder.withDescription((String)"Authorisation secret");
        OptionBuilder.withArgName((String)"Secret");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"x"));
        OptionBuilder.withLongOpt((String)"streams");
        OptionBuilder.withDescription((String)"Number of streams");
        OptionBuilder.withArgName((String)"Streams");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"encryption-key");
        OptionBuilder.withDescription((String)"Encryption key, Base64-encoded");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"base64Key");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"E"));
        OptionBuilder.withLongOpt((String)"buffersize");
        OptionBuilder.withDescription((String)"Buffer size in kbytes for reading/writing files (default 128)");
        OptionBuilder.withArgName((String)"bufferSize");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withDescription((String)"Local file name");
        OptionBuilder.withArgName((String)"File name");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"append");
        OptionBuilder.withDescription((String)"Append to an existing file");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"compress");
        OptionBuilder.withDescription((String)"Compress data");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"z"));
        return options;
    }

    public static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String syntax = "UFTPClient [OPTIONS]" + System.getProperty("line.separator");
        formatter.printHelp(syntax, options);
    }
}

