/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Element;

public class SecuritySessionUtils {
    public static final String SESSION_HDR_NS = "http://www.unicore.eu/unicore/ws";
    public static final String SESSION_HEADER = "SecuritySession";
    public static final QName headerQName = new QName("http://www.unicore.eu/unicore/ws", "SecuritySession");
    public static final QName idQName = new QName("http://www.unicore.eu/unicore/ws", "ID");
    public static final QName ltQName = new QName("http://www.unicore.eu/unicore/ws", "Lifetime");
    public static final String SESSION_TARGET_URL = "unicore-security-session-target-url";
    public static final String SESSION_ID_KEY = "unicore-security-session-id";
    public static final String REUSED_MARKER_KEY = "reused-unicore-security-session";

    public static Header buildHeader(String sessionID, long lifetime) {
        Element headerEl = null;
        StringBuilder sb = new StringBuilder();
        sb.append("<sid:SecuritySession xmlns:sid=\"http://www.unicore.eu/unicore/ws\">");
        sb.append("<sid:ID>" + sessionID + "</sid:ID>");
        if (lifetime > -1L) {
            sb.append("<sid:Lifetime>" + lifetime + "</sid:Lifetime>");
        }
        sb.append("</sid:SecuritySession>");
        try {
            byte[] asBytes = sb.toString().getBytes();
            headerEl = DOMUtils.readXml((InputStream)new ByteArrayInputStream(asBytes)).getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Header(headerQName, (Object)headerEl);
    }

    public static boolean haveSessionID(SoapMessage message) {
        return message.getContextualProperty(REUSED_MARKER_KEY) != null;
    }

    public static String getSecuritySessionID(SoapMessage message) {
        Element hdr;
        String sessionID = null;
        Header header = message.getHeader(headerQName);
        if (header != null && (hdr = (Element)header.getObject()) != null) {
            sessionID = hdr.getTextContent();
        }
        return sessionID;
    }
}

