/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.unicore.samly2.SAMLConstants;
import eu.unicore.samly2.exceptions.SAMLRequesterException;
import eu.unicore.samly2.exceptions.SAMLServerException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.samly2.validators.AbstractRequestValidator;
import eu.unicore.samly2.validators.ReplayAttackChecker;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestDocument;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestType;

public class SSOAuthnRequestValidator
extends AbstractRequestValidator {
    public SSOAuthnRequestValidator(String consumerEndpointUri, SamlTrustChecker trustChecker, long requestValidity, ReplayAttackChecker replayChecker) {
        super(consumerEndpointUri, trustChecker, requestValidity, replayChecker);
    }

    public void validate(AuthnRequestDocument authenticationRequestDoc) throws SAMLServerException {
        AuthnRequestType authnRequest = authenticationRequestDoc.getAuthnRequest();
        super.validate(authenticationRequestDoc, authnRequest);
        this.validateIssuer(authnRequest);
        if (this.trustChecker.isSignatureRequired() && (authnRequest.getSignature() == null || authnRequest.getSignature().isNil())) {
            throw new SAMLRequesterException(SAMLConstants.SubStatus.STATUS2_REQUEST_DENIED, "The request is not signed");
        }
    }

    protected void validateIssuer(AuthnRequestType authnRequest) throws SAMLServerException {
        NameIDType issuer = authnRequest.getIssuer();
        if (issuer == null) {
            throw new SAMLRequesterException("Issuer of SAML request must be present in SSO AuthN");
        }
        if (issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLRequesterException("Issuer of SAML request must be of Entity type in SSO AuthN. It is: " + issuer.getFormat());
        }
        if (issuer.getStringValue() == null) {
            throw new SAMLRequesterException("Issuer value of SAML request must be present in SSO AuthN");
        }
    }
}

