/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.lookup;

import de.fzj.unicore.uas.StorageFactory;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.StorageFactoryClient;
import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.uas.lookup.AddressFilter;
import de.fzj.unicore.uas.lookup.Lister;
import de.fzj.unicore.uas.lookup.Producer;
import de.fzj.unicore.uas.security.WSRFClientConfigurationProvider;
import de.fzj.unicore.uas.util.Pair;
import de.fzj.unicore.wsrflite.xmlbeans.client.IRegistryQuery;
import eu.unicore.security.wsutil.client.authn.DelegationSpecification;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageLister
extends Lister<StorageClient> {
    static final Logger log = Log.getLogger("unicore.client", StorageLister.class);
    private final IRegistryQuery registry;
    private final WSRFClientConfigurationProvider configurationProvider;
    private boolean includeSMF = true;
    private boolean includeTSS = true;
    private boolean includeSharedStorages = true;

    public StorageLister(IRegistryQuery registry, WSRFClientConfigurationProvider configurationProvider) {
        this(null, registry, configurationProvider, new Lister.AcceptAllFilter<StorageClient>());
    }

    public StorageLister(ExecutorService executor, IRegistryQuery registry, WSRFClientConfigurationProvider configurationProvider) {
        this(executor, registry, configurationProvider, new Lister.AcceptAllFilter<StorageClient>());
    }

    public StorageLister(ExecutorService executor, IRegistryQuery registry, WSRFClientConfigurationProvider configurationProvider, AddressFilter<StorageClient> addressFilter) {
        super(executor, addressFilter, Integer.MAX_VALUE);
        this.registry = registry;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public Iterator<StorageClient> iterator() {
        try {
            this.setupProducers();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return super.iterator();
    }

    protected void setupProducers() throws Exception {
        if (this.includeSMF) {
            List<EndpointReferenceType> smfs = this.registry.listAccessibleServices(StorageFactory.SMF_PORT);
            for (EndpointReferenceType smf : smfs) {
                if (!this.addressFilter.accept(smf)) continue;
                this.addProducer(new SMFProducer(smf, this.configurationProvider.getClientConfiguration(smf, DelegationSpecification.STANDARD), this.addressFilter));
            }
        }
        if (this.includeTSS) {
            List<EndpointReferenceType> tsfs = this.registry.listAccessibleServices(TargetSystemFactory.TSF_PORT);
            for (EndpointReferenceType tsf : tsfs) {
                if (!this.addressFilter.accept(tsf)) continue;
                this.addProducer(new TSSStorageProducer(tsf, this.configurationProvider.getClientConfiguration(tsf, DelegationSpecification.STANDARD), this.addressFilter));
            }
        }
        if (this.includeSharedStorages) {
            List<EndpointReferenceType> smss = this.registry.listAccessibleServices(StorageManagement.SMS_PORT);
            for (EndpointReferenceType sms : smss) {
                if (!this.addressFilter.accept(sms)) continue;
                this.addProducer(new StorageProducer(sms, this.configurationProvider.getClientConfiguration(sms, DelegationSpecification.STANDARD), this.addressFilter));
            }
        }
    }

    public void setIncludeSMF(boolean includeSMF) {
        this.includeSMF = includeSMF;
    }

    public void setIncludeTSS(boolean includeTSS) {
        this.includeTSS = includeTSS;
    }

    public void setIncludeSharedStorages(boolean includeSharedStorages) {
        this.includeSharedStorages = includeSharedStorages;
    }

    public static class TSSStorageProducer
    extends StorageProducer {
        public TSSStorageProducer(EndpointReferenceType epr, IClientConfiguration securityProperties, AddressFilter<StorageClient> filter) {
            super(epr, securityProperties, filter);
        }

        @Override
        public void handleEPR(EndpointReferenceType epr) throws Exception {
            TSFClient tsf = new TSFClient(epr, this.securityProperties);
            for (EndpointReferenceType tEpr : tsf.getAccessibleTargetSystems()) {
                if (!this.addressFilter.accept(tEpr)) continue;
                TSSClient tss = new TSSClient(tEpr, this.securityProperties);
                for (EndpointReferenceType sEpr : tss.getStorages()) {
                    StorageClient c = new StorageClient(sEpr, this.securityProperties);
                    if (!this.addressFilter.accept(c)) continue;
                    this.target.put(c);
                }
            }
        }
    }

    public static class SMFProducer
    extends StorageProducer {
        public SMFProducer(EndpointReferenceType epr, IClientConfiguration securityProperties, AddressFilter<StorageClient> filter) {
            super(epr, securityProperties, filter);
        }

        @Override
        public void handleEPR(EndpointReferenceType epr) throws Exception {
            StorageFactoryClient smf = new StorageFactoryClient(epr, this.securityProperties);
            for (EndpointReferenceType sEpr : smf.getAccessibleStorages()) {
                StorageClient c;
                if (!this.addressFilter.accept(sEpr) || !this.addressFilter.accept(c = new StorageClient(sEpr, this.securityProperties))) continue;
                this.target.put(c);
            }
        }
    }

    public static class StorageProducer
    implements Producer<StorageClient> {
        private final EndpointReferenceType epr;
        protected final IClientConfiguration securityProperties;
        protected final List<Pair<EndpointReferenceType, String>> errors = new ArrayList<Pair<EndpointReferenceType, String>>();
        private AtomicInteger runCount;
        protected BlockingQueue<StorageClient> target;
        protected AddressFilter<StorageClient> addressFilter;

        public StorageProducer(EndpointReferenceType epr, IClientConfiguration securityProperties, AddressFilter<StorageClient> addressFilter) {
            this.epr = epr;
            this.securityProperties = securityProperties;
            this.addressFilter = addressFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Processing storage(s) at " + this.epr.getAddress().getStringValue());
                }
                this.handleEPR(this.epr);
            }
            catch (Exception ex) {
                this.errors.add(new Pair<EndpointReferenceType, String>(this.epr, Log.createFaultMessage("", ex)));
            }
            finally {
                this.runCount.decrementAndGet();
            }
        }

        public void handleEPR(EndpointReferenceType epr) throws Exception {
            StorageClient c;
            if (this.addressFilter.accept(epr) && this.addressFilter.accept(c = new StorageClient(epr, this.securityProperties))) {
                this.target.put(c);
            }
        }

        @Override
        public void init(BlockingQueue<StorageClient> target, AtomicInteger runCount) {
            this.target = target;
            this.runCount = runCount;
        }
    }
}

