/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53domains.model.DomainSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDomainsResult
implements Serializable {
    private ListWithAutoConstructFlag<DomainSummary> domains;
    private String nextPageMarker;

    public List<DomainSummary> getDomains() {
        if (this.domains == null) {
            this.domains = new ListWithAutoConstructFlag();
            this.domains.setAutoConstruct(true);
        }
        return this.domains;
    }

    public void setDomains(Collection<DomainSummary> domains) {
        if (domains == null) {
            this.domains = null;
            return;
        }
        ListWithAutoConstructFlag domainsCopy = new ListWithAutoConstructFlag(domains.size());
        domainsCopy.addAll(domains);
        this.domains = domainsCopy;
    }

    public ListDomainsResult withDomains(DomainSummary ... domains) {
        if (this.getDomains() == null) {
            this.setDomains(new ArrayList<DomainSummary>(domains.length));
        }
        for (DomainSummary value : domains) {
            this.getDomains().add(value);
        }
        return this;
    }

    public ListDomainsResult withDomains(Collection<DomainSummary> domains) {
        if (domains == null) {
            this.domains = null;
        } else {
            ListWithAutoConstructFlag domainsCopy = new ListWithAutoConstructFlag(domains.size());
            domainsCopy.addAll(domains);
            this.domains = domainsCopy;
        }
        return this;
    }

    public String getNextPageMarker() {
        return this.nextPageMarker;
    }

    public void setNextPageMarker(String nextPageMarker) {
        this.nextPageMarker = nextPageMarker;
    }

    public ListDomainsResult withNextPageMarker(String nextPageMarker) {
        this.nextPageMarker = nextPageMarker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomains() != null) {
            sb.append("Domains: " + this.getDomains() + ",");
        }
        if (this.getNextPageMarker() != null) {
            sb.append("NextPageMarker: " + this.getNextPageMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomains() == null ? 0 : this.getDomains().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageMarker() == null ? 0 : this.getNextPageMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResult)) {
            return false;
        }
        ListDomainsResult other = (ListDomainsResult)obj;
        if (other.getDomains() == null ^ this.getDomains() == null) {
            return false;
        }
        if (other.getDomains() != null && !other.getDomains().equals(this.getDomains())) {
            return false;
        }
        if (other.getNextPageMarker() == null ^ this.getNextPageMarker() == null) {
            return false;
        }
        return other.getNextPageMarker() == null || other.getNextPageMarker().equals(this.getNextPageMarker());
    }
}

