/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.udp;

import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.datagram.DatagramEndpoint;
import org.apache.axis2.util.Utils;

public class Endpoint
extends DatagramEndpoint {
    private int port;
    private int maxPacketSize;

    public int getPort() {
        return this.port;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public String getDescription() {
        return "*:" + this.port;
    }

    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        this.port = ParamUtils.getOptionalParamInt(params, "transport.udp.port", -1);
        if (this.port == -1) {
            return false;
        }
        this.maxPacketSize = ParamUtils.getOptionalParamInt(params, "transport.udp.maxPacketSize", 1024);
        return super.loadConfiguration(params);
    }

    public EndpointReference[] getEndpointReferences(AxisService service, String ip) throws AxisFault {
        if (ip == null) {
            try {
                ip = Utils.getIpAddress(this.getListener().getConfigurationContext().getAxisConfiguration());
            }
            catch (SocketException ex) {
                throw new AxisFault("Unable to determine the host's IP address", ex);
            }
        }
        StringBuilder epr = new StringBuilder("udp://");
        epr.append(ip);
        epr.append(':');
        epr.append(this.getPort());
        if (this.getService() == null) {
            epr.append('/');
            epr.append(this.getConfigurationContext().getServiceContextPath());
            epr.append('/');
            epr.append(service.getName());
        }
        epr.append("?contentType=");
        epr.append(this.getContentType());
        return new EndpointReference[]{new EndpointReference(epr.toString())};
    }
}

