/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axiom.soap.SOAP12Constants;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpRequest;
import org.apache.axis2.transport.http.server.AxisHttpRequestImpl;
import org.apache.axis2.transport.http.server.AxisHttpResponse;
import org.apache.axis2.transport.http.server.AxisHttpResponseImpl;
import org.apache.axis2.transport.http.server.Worker;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

public class AxisHttpService {
    private static final Log LOG = LogFactory.getLog(AxisHttpService.class);
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    private final HttpResponseFactory responseFactory;
    private final ConfigurationContext configurationContext;
    private final Worker worker;
    private HttpParams params;

    public AxisHttpService(HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, ConfigurationContext configurationContext, Worker worker) {
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection strategy may not be null");
        }
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        if (worker == null) {
            throw new IllegalArgumentException("Worker may not be null");
        }
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context may not be null");
        }
        this.httpProcessor = httpProcessor;
        this.connStrategy = connStrategy;
        this.responseFactory = responseFactory;
        this.configurationContext = configurationContext;
        this.worker = worker;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setParams(HttpParams params) {
        this.params = params;
    }

    public void handleRequest(AxisHttpConnection conn, HttpContext context) throws IOException, HttpException {
        HttpResponse response;
        MessageContext msgContext = this.configurationContext.createMessageContext();
        msgContext.setIncomingTransportName("http");
        if (conn != null) {
            msgContext.setProperty("REMOTE_ADDR", conn.getRemoteAddress().getHostAddress());
            msgContext.setProperty("TRANSPORT_ADDR", conn.getLocalAddress().getHostAddress());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remote address of the connection : " + conn.getRemoteAddress().getHostAddress()));
            }
        }
        try {
            OutputStream outstream;
            HttpRequest request = conn.receiveRequest();
            RequestLine requestLine = request.getRequestLine();
            if (requestLine != null) {
                msgContext.setProperty("HTTP_METHOD_OBJECT", requestLine.getMethod());
            }
            request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.params));
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (!ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                ver = HttpVersion.HTTP_1_1;
            }
            response = this.responseFactory.newHttpResponse(ver, 200, context);
            response.setParams((HttpParams)new DefaultedHttpParams(response.getParams(), this.params));
            if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).expectContinue()) {
                HttpResponse ack = this.responseFactory.newHttpResponse(ver, 100, context);
                ack.setParams((HttpParams)new DefaultedHttpParams(ack.getParams(), this.params));
                conn.sendResponse(ack);
                conn.flush();
            }
            AxisHttpRequestImpl axisreq = new AxisHttpRequestImpl(conn, request, this.httpProcessor, context);
            AxisHttpResponseImpl axisres = new AxisHttpResponseImpl(conn, response, this.httpProcessor, context);
            axisreq.prepare();
            this.doService(axisreq, axisres, context, msgContext);
            InputStream instream = conn.getInputStream();
            if (instream != null) {
                instream.close();
            }
            if (!axisres.isCommitted()) {
                axisres.commit();
            }
            if ((outstream = conn.getOutputStream()) != null) {
                outstream.close();
            }
        }
        catch (HttpException ex) {
            response = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, context);
            response.setParams((HttpParams)new DefaultedHttpParams(response.getParams(), this.params));
            this.handleException(ex, response);
            this.httpProcessor.process(response, context);
            conn.sendResponse(response);
        }
        conn.flush();
        if (!this.connStrategy.keepAlive(response, context)) {
            conn.close();
        } else {
            conn.reset();
        }
    }

    protected void handleException(HttpException ex, HttpResponse response) {
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
    }

    protected void doService(AxisHttpRequest request, AxisHttpResponse response, HttpContext context, MessageContext msgContext) throws HttpException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Request method: " + request.getMethod()));
            LOG.debug((Object)("Target URI: " + request.getRequestURI()));
        }
        try {
            TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("http");
            TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("http");
            String sessionKey = (String)context.getAttribute("Cookie");
            msgContext.setTransportIn(transportIn);
            msgContext.setTransportOut(transportOut);
            msgContext.setServerSide(true);
            msgContext.setProperty("Cookie", sessionKey);
            msgContext.setProperty("TransportInURL", request.getRequestURI());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            HeaderIterator it = request.headerIterator();
            while (it.hasNext()) {
                Header header = (Header)it.next();
                headerMap.put(header.getName(), header.getValue());
            }
            msgContext.setProperty("TRANSPORT_HEADERS", headerMap);
            msgContext.setProperty("ContentType", request.getContentType());
            msgContext.setProperty("TRANSPORT_OUT", response.getOutputStream());
            msgContext.setProperty("OutTransportInfo", response);
            msgContext.setTo(new EndpointReference(request.getRequestURI()));
            msgContext.setProperty("RequestResponseTransportControl", new SimpleHTTPRequestResponseTransport());
            this.worker.service(request, response, msgContext);
        }
        catch (SocketException ex) {
            throw ex;
        }
        catch (HttpException ex) {
            throw ex;
        }
        catch (Throwable e) {
            msgContext.setProperty("TRANSPORT_OUT", response.getOutputStream());
            msgContext.setProperty("OutTransportInfo", response);
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgContext, e);
            if (AddressingHelper.isFaultRedirected(msgContext)) {
                response.setStatus(202);
            } else {
                String state = (String)msgContext.getProperty("axis2.http.response.state");
                if (state != null) {
                    int stateInt = Integer.parseInt(state);
                    response.setStatus(stateInt);
                    if (stateInt == 401) {
                        String realm = (String)msgContext.getProperty("axis2.authentication.realm");
                        response.addHeader("WWW-Authenticate", "basic realm=\"" + realm + "\"");
                    }
                } else if (e instanceof AxisFault) {
                    response.sendError(this.getStatusFromAxisFault((AxisFault)e), e.getMessage());
                } else {
                    response.sendError(500, "Internal server error");
                }
            }
            AxisEngine.sendFault(faultContext);
        }
    }

    public int getStatusFromAxisFault(AxisFault fault) {
        QName faultCode = fault.getFaultCode();
        if (SOAP12Constants.QNAME_SENDER_FAULTCODE.equals(faultCode) || SOAP11Constants.QNAME_SENDER_FAULTCODE.equals(faultCode)) {
            return 400;
        }
        return 500;
    }

    class SimpleHTTPRequestResponseTransport
    implements RequestResponseTransport {
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        AxisFault faultToBeThrownOut = null;
        private boolean responseWritten = false;

        SimpleHTTPRequestResponseTransport() {
        }

        public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            this.responseReadySignal.countDown();
        }

        public void awaitResponse() throws InterruptedException, AxisFault {
            this.responseReadySignal.await();
            if (this.faultToBeThrownOut != null) {
                throw this.faultToBeThrownOut;
            }
        }

        public void signalResponseReady() {
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public void signalFaultReady(AxisFault fault) {
            this.faultToBeThrownOut = fault;
            this.signalResponseReady();
        }

        public boolean isResponseWritten() {
            return this.responseWritten;
        }

        public void setResponseWritten(boolean responseWritten) {
            this.responseWritten = responseWritten;
        }
    }
}

