/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.aurora.client;

import org.apache.airavata.cloud.aurora.client.sdk.AuroraSchedulerManager;
import org.apache.airavata.cloud.aurora.client.sdk.ReadOnlyScheduler;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuroraSchedulerClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(AuroraSchedulerClientFactory.class);

    public static ReadOnlyScheduler.Client createReadOnlySchedulerClient(String connectionUrl, int connectionTimeout) throws Exception {
        try {
            return new ReadOnlyScheduler.Client(AuroraSchedulerClientFactory.getTProtocol(connectionUrl, connectionTimeout));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public static AuroraSchedulerManager.Client createSchedulerManagerClient(String connectionUrl, int connectionTimeout) throws Exception {
        try {
            return new AuroraSchedulerManager.Client(AuroraSchedulerClientFactory.getTProtocol(connectionUrl, connectionTimeout));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private static TProtocol getTProtocol(String connectionUrl, int connectionTimeout) throws Exception {
        try {
            THttpClient client = new THttpClient(connectionUrl);
            client.setConnectTimeout(connectionTimeout);
            THttpClient transport = client;
            transport.open();
            TJSONProtocol protocol = new TJSONProtocol((TTransport)transport);
            return protocol;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

