/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.configuration;

import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Configurations {
    public static void killLog4J() {
        ArrayList<Logger> loggers = Collections.list(LogManager.getCurrentLoggers());
        loggers.add(LogManager.getRootLogger());
        for (Logger logger : loggers) {
            logger.setLevel(Level.OFF);
        }
    }

    public static XMLConfiguration getConfiguration(File file) {
        if (file == null) {
            throw new MyConfigurationException("Error: no configuration file");
        }
        if (!file.exists()) {
            throw new MyConfigurationException("Error: file \"" + file.getAbsolutePath() + "\" does not exist");
        }
        if (!file.isFile()) {
            throw new MyConfigurationException("Error: \"" + file.getAbsolutePath() + "\" is not a file");
        }
        AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
        return Configurations.resolveFileReferences(file);
    }

    public static XMLConfiguration resolveFileReferences(File file) {
        TreeSet<String> visitedFiles = new TreeSet<String>();
        visitedFiles.add(file.getAbsolutePath());
        try {
            XMLConfiguration cfg = new XMLConfiguration(file);
            return Configurations.resolveFileReferences(cfg, visitedFiles);
        }
        catch (ConfigurationException e) {
            throw new MyConfigurationException("Error: Could not create configuration from file \"" + file + "\"", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static XMLConfiguration resolveFileReferences(XMLConfiguration cfg, TreeSet<String> visitedFiles) throws ConfigurationException {
        List list = cfg.getRoot().getChildren("file");
        for (int i = 0; i < list.size(); ++i) {
            ConfigurationNode cn = (ConfigurationNode)list.get(i);
            List nameAttribs = cn.getAttributes("include");
            for (int j = 0; j < nameAttribs.size(); ++j) {
                ConfigurationNode attrcn = (ConfigurationNode)nameAttribs.get(j);
                String currentFile = (String)attrcn.getValue();
                if (visitedFiles.contains(currentFile)) continue;
                visitedFiles.add(currentFile);
                FileInputStream fis = null;
                try {
                    File x = new File(currentFile);
                    if (x.isDirectory()) {
                        System.out.println("Configuration error: The file named \"" + currentFile + "\" is a directory. Skipping...");
                        continue;
                    }
                    if (!x.exists()) {
                        System.out.println("Configuration error: The file named \"" + currentFile + "\" does not exist. Skipping...");
                        continue;
                    }
                    if (x.canRead()) {
                        fis = new FileInputStream(x);
                        cfg.load((InputStream)fis);
                        fis.close();
                        Configurations.resolveFileReferences(cfg, visitedFiles);
                        continue;
                    }
                    System.out.println("Configuration error: The file named \"" + currentFile + "\" cannot be read (permission issue?). Skipping...");
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.out.println("Configuration error: Could not find the file named \"" + currentFile + "\". Skipping...");
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Configuration error: Some error processing \"" + currentFile + "\" happened. Message read \"" + e.getMessage() + "\". Skipping...");
                    continue;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            System.out.println("IOException. Could not close the file \"" + currentFile + "\". Skipping...");
                        }
                    }
                }
            }
        }
        return cfg;
    }

    public static XMLConfiguration getConfiguration(URL resourceName) {
        try {
            AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
            return new XMLConfiguration(resourceName);
        }
        catch (ConfigurationException cx) {
            throw new MyConfigurationException("Error: could not get configuration for resource " + resourceName, cx);
        }
    }

    public static String getNodeValue(ConfigurationNode node, String name) {
        ConfigurationNode node1 = Configurations.getFirstNode(node, name);
        if (node1 == null) {
            return null;
        }
        return node1.getValue().toString();
    }

    public static ConfigurationNode getFirstNode(ConfigurationNode node, String name) {
        List list = node.getChildren(name);
        if (list.isEmpty()) {
            return null;
        }
        return (ConfigurationNode)list.get(0);
    }

    public static String getFirstAttribute(ConfigurationNode node, String name) {
        List list = node.getAttributes(name);
        if (list.isEmpty()) {
            return null;
        }
        ConfigurationNode cn = (ConfigurationNode)list.get(0);
        return cn.getValue().toString();
    }

    public static String getNodeValue(ConfigurationNode node, String name, String defaultValue) {
        String x = Configurations.getNodeValue(node, name);
        return x == null ? defaultValue : x;
    }

    public static ConfigurationNode getConfig(XMLConfiguration cfg, String topNodeName, String configName) {
        TreeSet<String> checkedAliases = new TreeSet<String>();
        return Configurations.getConfig(cfg, topNodeName, configName, checkedAliases);
    }

    protected static ConfigurationNode getConfig(XMLConfiguration cfg, String topNodeName, String configName, TreeSet<String> checkedAliases) {
        List list = cfg.configurationsAt(topNodeName);
        ConfigurationNode configurationNode = null;
        for (int i = 0; i < list.size(); ++i) {
            SubnodeConfiguration cn = (SubnodeConfiguration)list.get(i);
            List nameAttribs = cn.getRootNode().getAttributes("name");
            for (int j = 0; j < nameAttribs.size(); ++j) {
                ConfigurationNode attrcn = (ConfigurationNode)nameAttribs.get(j);
                if (!attrcn.getValue().equals(configName)) continue;
                configurationNode = cn.getRootNode();
            }
            if (configurationNode == null) continue;
            String alias = Configurations.getFirstAttribute(configurationNode, "alias");
            if (alias != null && 0 < alias.length()) {
                if (checkedAliases.contains(alias)) {
                    throw new MyConfigurationException("Recursive error. The configuration \"" + configName + "\" contains an alias \"" + alias + "\" which refers to itself on resolution. Configuration load is aborted.");
                }
                checkedAliases.add(alias);
                return Configurations.getConfig(cfg, topNodeName, alias, checkedAliases);
            }
            return configurationNode;
        }
        throw new MyConfigurationException("Configuration \"" + configName + "\" not found");
    }
}

