/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.tenant.TenantDomainEntry;
import org.wso2.carbon.user.core.tenant.TenantIdKey;

class TenantDomainCache {
    private static Log log = LogFactory.getLog(TenantDomainCache.class);
    public static final String TENANT_DOMAIN_CACHE_MANAGER = "TENANT_DOMAIN_CACHE_MANAGER";
    public static final String TENANT_DOMAIN_CACHE = "TENANT_DOMAIN_CACHE";
    private static TenantDomainCache tenantDomainCache = new TenantDomainCache();

    private TenantDomainCache() {
    }

    private Cache<TenantIdKey, TenantDomainEntry> getTenantDomainCache() {
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(TENANT_DOMAIN_CACHE_MANAGER);
        Cache cache = cacheManager.getCache(TENANT_DOMAIN_CACHE);
        return cache;
    }

    public static synchronized TenantDomainCache getInstance() {
        return tenantDomainCache;
    }

    public void addToCache(TenantIdKey key, TenantDomainEntry entry) {
        this.clearCacheEntry(key);
        Cache<TenantIdKey, TenantDomainEntry> cache = this.getTenantDomainCache();
        if (cache != null) {
            cache.put((Object)key, (Object)entry);
            log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, added the entry : " + entry + " for the key : " + key + " successfully"));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Error while getting the cache : TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER");
        }
    }

    public TenantDomainEntry getValueFromCache(TenantIdKey key) {
        Cache<TenantIdKey, TenantDomainEntry> cache = this.getTenantDomainCache();
        if (cache != null) {
            if (cache.containsKey((Object)key)) {
                TenantDomainEntry entry = (TenantDomainEntry)cache.get((Object)key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, found the entry : " + entry + " for the key : " + key + " successfully"));
                }
                return entry;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, doesn't contain the key : " + key));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Error while getting the cache : TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER");
        }
        return null;
    }

    public void clearCacheEntry(TenantIdKey key) {
        Cache<TenantIdKey, TenantDomainEntry> cache = this.getTenantDomainCache();
        if (cache != null) {
            if (cache.containsKey((Object)key)) {
                cache.remove((Object)key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, is removed entry for the key : " + key + " successfully"));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, doen't contain the key : " + key));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Error while getting the cache : TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER");
        }
    }

    public void clear() {
        Cache<TenantIdKey, TenantDomainEntry> cache = this.getTenantDomainCache();
        if (cache != null) {
            cache.removeAll();
            if (log.isDebugEnabled()) {
                log.debug((Object)"TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER, is cleared successfully");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Error while getting the cache : TENANT_DOMAIN_CACHE which is under TENANT_DOMAIN_CACHE_MANAGER");
        }
    }
}

