/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.DefaultClaimManager;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilder;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilderException;
import org.wso2.carbon.user.core.claim.dao.ClaimDAO;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.profile.builder.ProfileBuilderException;
import org.wso2.carbon.user.core.profile.builder.ProfileConfigurationBuilder;
import org.wso2.carbon.user.core.util.DatabaseUtil;

public class DefaultRealm
implements UserRealm {
    private static Log log = LogFactory.getLog(DefaultRealm.class);
    private ClaimManager claimMan = null;
    private DataSource dataSource = null;
    private RealmConfiguration realmConfig = null;
    private int tenantId;
    private UserStoreManager userStoreManager = null;
    private AuthorizationManager authzManager = null;
    private Map<String, Object> properties = null;

    @Override
    public void init(RealmConfiguration configBean, Map<String, ClaimMapping> claimMappings, Map<String, ProfileConfiguration> profileConfigs, int tenantId) throws UserStoreException {
        if (claimMappings == null) {
            claimMappings = this.loadDefaultClaimMapping();
        }
        if (profileConfigs == null) {
            profileConfigs = this.loadDefaultProfileConfiguration();
        }
        this.realmConfig = configBean;
        this.properties = new Hashtable<String, Object>();
        this.tenantId = tenantId;
        this.dataSource = DatabaseUtil.getRealmDataSource(this.realmConfig);
        this.properties.put("um.datasource", this.dataSource);
        this.claimMan = new DefaultClaimManager(claimMappings, this.dataSource, tenantId);
        this.initializeObjects();
    }

    @Override
    public void init(RealmConfiguration configBean, Map<String, Object> propertiesMap, int tenantId) throws UserStoreException {
        if (configBean == null) {
            configBean = this.loadDefaultRealmConfigs();
        }
        this.realmConfig = configBean;
        this.properties = new Hashtable<String, Object>();
        this.tenantId = tenantId;
        this.properties = propertiesMap;
        this.dataSource = (DataSource)this.properties.get("um.datasource");
        HashMap<String, ClaimMapping> claimMappings = new HashMap<String, ClaimMapping>();
        HashMap<String, ProfileConfiguration> profileConfigs = new HashMap<String, ProfileConfiguration>();
        this.populateProfileAndClaimMaps(claimMappings, profileConfigs);
        this.claimMan = new DefaultClaimManager(claimMappings, this.dataSource, tenantId);
        this.initializeObjects();
    }

    @Override
    public UserStoreManager getUserStoreManager() throws UserStoreException {
        return this.userStoreManager;
    }

    public void addSecondaryUserStoreManager(RealmConfiguration userStoreRealmConfig) throws UserStoreException {
        String value = userStoreRealmConfig.getUserStoreClass();
        if (value == null) {
            log.error((Object)"Unable to add user store. UserStoreManager class name is null.");
        } else {
            try {
                UserStoreManager manager = (UserStoreManager)this.createObjectWithOptions(value, userStoreRealmConfig, this.properties);
                String domainName = userStoreRealmConfig.getUserStoreProperty("DomainName");
                if (domainName != null) {
                    if (this.isDuplicateDomain(domainName).booleanValue()) {
                        log.error((Object)"Could not initialize new user store manager.Duplicate domain names not allowed.");
                        return;
                    }
                    UserStoreManager tmpUserStoreManager = this.userStoreManager;
                    while (tmpUserStoreManager.getSecondaryUserStoreManager() != null) {
                        tmpUserStoreManager = tmpUserStoreManager.getSecondaryUserStoreManager();
                    }
                    tmpUserStoreManager.setSecondaryUserStoreManager(manager);
                    this.userStoreManager.addSecondaryUserStoreManager(domainName, tmpUserStoreManager.getSecondaryUserStoreManager());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("UserStoreManager : " + domainName + "added to the list"));
                    }
                    Boolean isDisabled = false;
                    if (userStoreRealmConfig.getUserStoreProperty("Disabled") != null && (isDisabled = Boolean.valueOf(Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("Disabled")))).booleanValue()) {
                        log.warn((Object)("Secondary user store disabled with domain " + domainName + "."));
                    }
                } else {
                    log.warn((Object)"Could not initialize new user store manager.  Domain name is not defined");
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not initialize secondary user store manager", (Throwable)e);
            }
        }
    }

    @Override
    public AuthorizationManager getAuthorizationManager() throws UserStoreException {
        return this.authzManager;
    }

    @Override
    public ClaimManager getClaimManager() throws UserStoreException {
        return this.claimMan;
    }

    @Override
    public ProfileConfigurationManager getProfileConfigurationManager() throws UserStoreException {
        return null;
    }

    @Override
    public void cleanUp() throws UserStoreException {
    }

    @Override
    public RealmConfiguration getRealmConfiguration() throws UserStoreException {
        return this.realmConfig;
    }

    private void initializeObjects() throws UserStoreException {
        try {
            String value = this.realmConfig.getUserStoreClass();
            if (value == null) {
                log.info((Object)"System is functioning without user store writing ability. User add/edit/delete will not work");
            } else {
                this.userStoreManager = (UserStoreManager)this.createObjectWithOptions(value, this.realmConfig, this.properties);
            }
            RealmConfiguration tmpRealmConfig = this.realmConfig.getSecondaryRealmConfig();
            UserStoreManager tmpUserStoreManager = this.userStoreManager;
            String domainName = this.realmConfig.getUserStoreProperty("DomainName");
            if (domainName != null) {
                this.userStoreManager.addSecondaryUserStoreManager(domainName, this.userStoreManager);
            }
            boolean isDisabled = false;
            if (this.realmConfig.getUserStoreProperty("Disabled") != null && (isDisabled = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("Disabled")))) {
                log.warn((Object)"You cannot disable the primary user store.");
            }
            while (tmpRealmConfig != null) {
                block17: {
                    value = tmpRealmConfig.getUserStoreClass();
                    if (value == null) {
                        log.info((Object)"System is functioning without user store writing ability. User add/edit/delete will not work");
                    } else {
                        try {
                            UserStoreManager manager = (UserStoreManager)this.createObjectWithOptions(value, tmpRealmConfig, this.properties);
                            domainName = tmpRealmConfig.getUserStoreProperty("DomainName");
                            if (domainName != null) {
                                if (this.userStoreManager.getSecondaryUserStoreManager(domainName) != null) {
                                    log.warn((Object)"Could not initialize secondary user store manager.Duplicate domain names not allowed.");
                                    tmpRealmConfig = tmpRealmConfig.getSecondaryRealmConfig();
                                    continue;
                                }
                                isDisabled = false;
                                if (tmpRealmConfig.getUserStoreProperty("Disabled") != null && (isDisabled = Boolean.parseBoolean(tmpRealmConfig.getUserStoreProperty("Disabled")))) {
                                    log.warn((Object)("Secondary user store disabled with domain " + domainName + "."));
                                    tmpRealmConfig = tmpRealmConfig.getSecondaryRealmConfig();
                                    continue;
                                }
                                tmpUserStoreManager.setSecondaryUserStoreManager(manager);
                                this.userStoreManager.addSecondaryUserStoreManager(domainName, tmpUserStoreManager.getSecondaryUserStoreManager());
                                break block17;
                            }
                            log.warn((Object)"Could not initialize secondary user store manager.  Domain name is not defined");
                            tmpRealmConfig = tmpRealmConfig.getSecondaryRealmConfig();
                        }
                        catch (Exception e) {
                            if (tmpRealmConfig.isPrimary()) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                                throw new UserStoreException("Cannot create connection to the primary user store. Error message " + e.getMessage());
                            }
                            log.warn((Object)"Could not initialize secondary user store manager", (Throwable)e);
                            tmpRealmConfig = tmpRealmConfig.getSecondaryRealmConfig();
                        }
                        continue;
                    }
                }
                tmpUserStoreManager = tmpUserStoreManager.getSecondaryUserStoreManager();
                tmpRealmConfig = tmpRealmConfig.getSecondaryRealmConfig();
            }
            value = this.realmConfig.getAuthorizationManagerClass();
            if (value == null) {
                String message = "System cannot continue. Authorization writer is null";
                log.error((Object)message);
                throw new UserStoreException(message);
            }
            this.authzManager = (AuthorizationManager)this.createObjectWithOptions(value, this.realmConfig, this.properties);
        }
        catch (UserStoreException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private Object createObjectWithOptions(String className, RealmConfiguration realmConfig, Map properties) throws UserStoreException {
        Class[] initClassOpt1 = new Class[]{RealmConfiguration.class, Map.class, ClaimManager.class, ProfileConfigurationManager.class, UserRealm.class, Integer.class};
        Object[] initObjOpt1 = new Object[]{realmConfig, properties, this.claimMan, null, this, this.tenantId};
        Class[] initClassOpt2 = new Class[]{RealmConfiguration.class, Map.class, ClaimManager.class, ProfileConfigurationManager.class, UserRealm.class};
        Object[] initObjOpt2 = new Object[]{realmConfig, properties, this.claimMan, null, this};
        Class[] initClassOpt3 = new Class[]{RealmConfiguration.class, Map.class};
        Object[] initObjOpt3 = new Object[]{realmConfig, properties};
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = null;
            Object newObject = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start initializing class with the first option");
            }
            try {
                constructor = clazz.getConstructor(initClassOpt1);
                newObject = constructor.newInstance(initObjOpt1);
                return newObject;
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannont initialize " + className + " using the option 1"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"End initializing class with the first option");
                }
                try {
                    constructor = clazz.getConstructor(initClassOpt2);
                    newObject = constructor.newInstance(initObjOpt2);
                    return newObject;
                }
                catch (NoSuchMethodException e2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cannont initialize " + className + " using the option 2"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"End initializing class with the second option");
                    }
                    try {
                        constructor = clazz.getConstructor(initClassOpt3);
                        newObject = constructor.newInstance(initObjOpt3);
                        return newObject;
                    }
                    catch (NoSuchMethodException e3) {
                        String message = "Cannot initialize " + className + ". Error " + e3.getMessage();
                        log.error((Object)message);
                        throw new UserStoreException(message);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)("Cannot create " + className), e);
            throw new UserStoreException(e.getMessage() + "Type " + e.getClass(), e);
        }
    }

    private RealmConfiguration loadDefaultRealmConfigs() throws UserStoreException {
        RealmConfigXMLProcessor processor = new RealmConfigXMLProcessor();
        RealmConfiguration config = processor.buildRealmConfigurationFromFile();
        return config;
    }

    private Map<String, ClaimMapping> loadDefaultClaimMapping() throws UserStoreException {
        try {
            ClaimBuilder claimBuilder = new ClaimBuilder(this.tenantId);
            Map<String, ClaimMapping> claimMapping = claimBuilder.buildClaimMappingsFromConfigFile();
            return claimMapping;
        }
        catch (ClaimBuilderException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private Map<String, ProfileConfiguration> loadDefaultProfileConfiguration() throws UserStoreException {
        try {
            ProfileConfigurationBuilder profilBuilder = new ProfileConfigurationBuilder(this.tenantId);
            Map<String, ProfileConfiguration> profileConfig = profilBuilder.buildProfileConfigurationFromConfigFile();
            return profileConfig;
        }
        catch (ProfileBuilderException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }

    private void populateProfileAndClaimMaps(Map<String, ClaimMapping> claimMappings, Map<String, ProfileConfiguration> profileConfigs) throws UserStoreException {
        ClaimDAO claimDAO = new ClaimDAO(this.dataSource, this.tenantId);
        ClaimBuilder claimBuilder = new ClaimBuilder(this.tenantId);
        int count = claimDAO.getDialectCount();
        if (count == 0) {
            try {
                claimMappings.putAll(claimBuilder.buildClaimMappingsFromConfigFile());
            }
            catch (ClaimBuilderException e) {
                String msg = "Error in building claims.";
                log.error((Object)msg);
                throw new UserStoreException(msg, e);
            }
            claimDAO.addCliamMappings(claimMappings.values().toArray(new ClaimMapping[claimMappings.size()]));
        } else {
            try {
                claimMappings.putAll(claimBuilder.buildClaimMappingsFromDatabase(this.dataSource, "Internal"));
            }
            catch (ClaimBuilderException e) {
                String msg = "Error in building claims.";
                log.error((Object)msg);
                throw new UserStoreException(msg, e);
            }
        }
    }

    public Boolean isDuplicateDomain(String domainName) {
        if (this.userStoreManager.getSecondaryUserStoreManager(domainName) != null) {
            return true;
        }
        return false;
    }
}

