/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class SearchResultEntryDecorator
extends MessageDecorator<SearchResultEntry>
implements SearchResultEntry {
    private byte[] objectNameBytes;
    private int searchResultEntryLength;
    private int attributesLength;
    private List<Integer> attributeLength;
    private List<byte[]> attributeIds;
    private List<Integer> valuesLength;
    private Attribute currentAttribute;

    public SearchResultEntryDecorator(LdapApiService codec, SearchResultEntry decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public Attribute getCurrentAttribute() {
        return this.currentAttribute;
    }

    public void addAttribute(String type) throws LdapException {
        this.currentAttribute = new DefaultAttribute(type);
        ((SearchResultEntry)this.getDecorated()).getEntry().put(this.currentAttribute);
    }

    public void addAttribute(byte[] type) throws LdapException {
        this.currentAttribute = new DefaultAttribute(type);
        ((SearchResultEntry)this.getDecorated()).getEntry().put(this.currentAttribute);
    }

    public void addAttributeValue(Object value) throws LdapException {
        if (value instanceof String) {
            this.currentAttribute.add((String)value);
        } else {
            this.currentAttribute.add(new byte[][]{(byte[])value});
        }
    }

    @Override
    public Dn getObjectName() {
        return ((SearchResultEntry)this.getDecorated()).getObjectName();
    }

    @Override
    public void setObjectName(Dn objectName) {
        ((SearchResultEntry)this.getDecorated()).setObjectName(objectName);
    }

    @Override
    public Entry getEntry() {
        return ((SearchResultEntry)this.getDecorated()).getEntry();
    }

    @Override
    public void setEntry(Entry entry) {
        ((SearchResultEntry)this.getDecorated()).setEntry(entry);
    }

    @Override
    public int computeLength() {
        Dn dn = this.getObjectName();
        this.objectNameBytes = Strings.getBytesUtf8Ascii(dn.getName());
        this.searchResultEntryLength = 1 + TLV.getNbBytes(this.objectNameBytes.length) + this.objectNameBytes.length;
        this.attributesLength = 0;
        Entry entry = this.getEntry();
        if (entry != null && entry.size() != 0) {
            this.attributeLength = new LinkedList<Integer>();
            this.attributeIds = new LinkedList<byte[]>();
            this.valuesLength = new LinkedList<Integer>();
            this.valuesLength = new LinkedList<Integer>();
            for (Attribute attribute : entry) {
                int localValuesLength = 0;
                byte[] attributeIdBytes = Strings.getBytesUtf8Ascii(attribute.getUpId());
                this.attributeIds.add(attributeIdBytes);
                int idLength = attributeIdBytes.length;
                int localAttributeLength = 1 + TLV.getNbBytes(idLength) + idLength;
                if (attribute.size() != 0) {
                    if (attribute.size() > 0) {
                        localValuesLength = 0;
                        for (Value value : attribute) {
                            byte[] binaryValue = value.getBytes();
                            localValuesLength += 1 + TLV.getNbBytes(binaryValue.length) + binaryValue.length;
                        }
                        localAttributeLength += 1 + TLV.getNbBytes(localValuesLength) + localValuesLength;
                    } else {
                        localAttributeLength += 2;
                    }
                } else {
                    localAttributeLength += 2;
                }
                this.attributesLength += 1 + TLV.getNbBytes(localAttributeLength) + localAttributeLength;
                this.attributeLength.add(localAttributeLength);
                this.valuesLength.add(localValuesLength);
            }
        }
        this.searchResultEntryLength += 1 + TLV.getNbBytes(this.attributesLength) + this.attributesLength;
        return 1 + TLV.getNbBytes(this.searchResultEntryLength) + this.searchResultEntryLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)100);
            buffer.put(TLV.getBytes(this.searchResultEntryLength));
            BerValue.encode(buffer, this.objectNameBytes);
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes(this.attributesLength));
            Entry entry = this.getEntry();
            if (entry != null && entry.size() != 0) {
                int attributeNumber = 0;
                for (Attribute attribute : entry) {
                    buffer.put(UniversalTag.SEQUENCE.getValue());
                    int localAttributeLength = this.attributeLength.get(attributeNumber);
                    buffer.put(TLV.getBytes(localAttributeLength));
                    BerValue.encode(buffer, this.attributeIds.get(attributeNumber));
                    buffer.put(UniversalTag.SET.getValue());
                    int localValuesLength = this.valuesLength.get(attributeNumber);
                    buffer.put(TLV.getBytes(localValuesLength));
                    if (attribute.size() > 0) {
                        for (Value value : attribute) {
                            BerValue.encode(buffer, value.getBytes());
                        }
                    }
                    ++attributeNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]), boe);
        }
        return buffer;
    }
}

