/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.util.KeyStoreManager;

public class SignatureUtil {
    private static final String THUMB_DIGEST_ALGORITHM = "SHA-1";
    private static String signatureAlgorithm = "SHA1withRSA";
    private static String provider = "BC";

    private SignatureUtil() {
    }

    public static void init() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static byte[] getThumbPrintForAlias(String alias) throws Exception {
        MessageDigest sha = MessageDigest.getInstance(THUMB_DIGEST_ALGORITHM);
        sha.reset();
        Certificate cert = SignatureUtil.getCertificate(alias);
        sha.update(cert.getEncoded());
        return sha.digest();
    }

    public static boolean validateSignature(byte[] thumb, String data, byte[] signature) throws Exception {
        Signature signer = Signature.getInstance(signatureAlgorithm, provider);
        signer.initVerify(SignatureUtil.getPublicKey(thumb));
        signer.update(data.getBytes());
        return signer.verify(signature);
    }

    public static boolean validateSignature(String data, byte[] signature) throws Exception {
        Signature signer = Signature.getInstance(signatureAlgorithm, provider);
        signer.initVerify(SignatureUtil.getDefaultPublicKey());
        signer.update(data.getBytes());
        return signer.verify(signature);
    }

    public static byte[] doSignature(String data) throws Exception {
        Signature signer = Signature.getInstance(signatureAlgorithm, provider);
        signer.initSign(SignatureUtil.getDefaultPrivateKey());
        signer.update(data.getBytes());
        return signer.sign();
    }

    private static PrivateKey getDefaultPrivateKey() throws Exception {
        KeyStoreManager keyStoreMan = KeyStoreManager.getInstance(-1234);
        KeyStore keyStore = keyStoreMan.getPrimaryKeyStore();
        ServerConfigurationService config = CarbonCoreDataHolder.getInstance().getServerConfigurationService();
        String password = config.getFirstProperty("Security.KeyStore.Password");
        String alias = config.getFirstProperty("Security.KeyStore.KeyAlias");
        return (PrivateKey)keyStore.getKey(alias, password.toCharArray());
    }

    private static PublicKey getDefaultPublicKey() throws Exception {
        KeyStoreManager keyStoreMan = KeyStoreManager.getInstance(-1234);
        KeyStore keyStore = keyStoreMan.getPrimaryKeyStore();
        ServerConfigurationService config = CarbonCoreDataHolder.getInstance().getServerConfigurationService();
        String alias = config.getFirstProperty("Security.KeyStore.KeyAlias");
        return keyStore.getCertificate(alias).getPublicKey();
    }

    private static PublicKey getPublicKey(byte[] thumb) throws Exception {
        KeyStoreManager keyStoreMan = KeyStoreManager.getInstance(-1234);
        KeyStore keyStore = keyStoreMan.getPrimaryKeyStore();
        PublicKey pubKey = null;
        Certificate cert = null;
        MessageDigest sha = MessageDigest.getInstance(THUMB_DIGEST_ALGORITHM);
        sha.reset();
        Enumeration<String> e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            cert = SignatureUtil.getCertificate(alias);
            sha.update(cert.getEncoded());
            byte[] data = sha.digest();
            if (!Arrays.equals(data, thumb)) continue;
            pubKey = cert.getPublicKey();
            break;
        }
        return pubKey;
    }

    private static Certificate getCertificate(String alias) throws Exception {
        KeyStoreManager keyStoreMan = KeyStoreManager.getInstance(-1234);
        KeyStore keyStore = keyStoreMan.getPrimaryKeyStore();
        Certificate cert = null;
        Certificate[] certs = keyStore.getCertificateChain(alias);
        cert = certs == null || certs.length == 0 ? keyStore.getCertificate(alias) : certs[0];
        if (!(cert instanceof X509Certificate)) {
            throw new Exception("Please check alias. Cannot retrieve valid certificate");
        }
        return cert;
    }
}

