/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import java.io.File;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.apache.axis2.AxisFault;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;

public class KeyStoreUtil {
    public static String getPrivateKeyAlias(KeyStore store) throws Exception {
        String alias = null;
        Enumeration<String> enums = store.aliases();
        while (enums.hasMoreElements()) {
            String name = enums.nextElement();
            if (!store.isKeyEntry(name)) continue;
            alias = name;
            break;
        }
        return alias;
    }

    public static String getKeyStoreFileName(String fullName) {
        ServerConfigurationService config = CarbonCoreDataHolder.getInstance().getServerConfigurationService();
        String fileName = config.getFirstProperty("Security.KeyStore.Location");
        String name = null;
        int index = fileName.lastIndexOf(47);
        name = index != -1 ? fileName.substring(index + 1) : ((index = fileName.lastIndexOf(File.separatorChar)) != -1 ? fileName.substring(fileName.lastIndexOf(File.separatorChar)) : fileName);
        return name;
    }

    public static boolean isPrimaryStore(String id) {
        ServerConfigurationService config = CarbonCoreDataHolder.getInstance().getServerConfigurationService();
        String fileName = config.getFirstProperty("Security.KeyStore.Location");
        int index = fileName.lastIndexOf(47);
        if (index != -1) {
            String name = fileName.substring(index + 1);
            if (name.equals(id)) {
                return true;
            }
        } else {
            index = fileName.lastIndexOf(File.separatorChar);
            String name = null;
            name = index != -1 ? fileName.substring(fileName.lastIndexOf(File.separatorChar)) : fileName;
            if (name.equals(id)) {
                return true;
            }
        }
        return false;
    }

    public static Certificate getCertificate(String alias, KeyStore store) throws AxisFault {
        try {
            Enumeration<String> enumeration = store.aliases();
            while (enumeration.hasMoreElements()) {
                String itemAlias = enumeration.nextElement();
                if (!itemAlias.equals(alias)) continue;
                return store.getCertificate(alias);
            }
            return null;
        }
        catch (Exception e) {
            String msg = "Could not read certificates from keystore file. ";
            throw new AxisFault(msg + e.getMessage());
        }
    }
}

