/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.wso2.carbon.core.transports.util.TransportParameter;

public class TransportBuilderUtils
implements DeploymentConstants {
    public static TransportInDescription processTransportReceiver(OMElement transport, boolean init) throws DeploymentException {
        if (!"transportReceiver".equals(transport.getLocalName())) {
            throw new DeploymentException("Invalid top level element in the transport receiver configuration");
        }
        String name = transport.getAttributeValue(new QName("name"));
        if (name == null || "".equals(name)) {
            throw new DeploymentException("Transport name is not specified in the receiver configuration");
        }
        String className = transport.getAttributeValue(new QName("class"));
        if (className == null || "".equals(className)) {
            throw new DeploymentException("Class name is not specified in the receiver configuration");
        }
        TransportInDescription transportIn = new TransportInDescription(name);
        if (init) {
            try {
                Class<?> clazz = TransportBuilderUtils.class.getClassLoader().loadClass(className);
                TransportListener listener = (TransportListener)clazz.newInstance();
                transportIn.setReceiver(listener);
            }
            catch (Exception e) {
                throw new DeploymentException("Error while initializing transport receiver", (Throwable)e);
            }
        }
        Iterator itr = transport.getChildrenWithName(new QName("parameter"));
        TransportBuilderUtils.processParameters(itr, (ParameterInclude)transportIn);
        return transportIn;
    }

    public static TransportOutDescription processTransportSender(OMElement transport, boolean init) throws DeploymentException {
        if (!"transportSender".equals(transport.getLocalName())) {
            throw new DeploymentException("Invalid top level element in the transport sender configuration");
        }
        String name = transport.getAttributeValue(new QName("name"));
        if (name == null || "".equals(name)) {
            throw new DeploymentException("Transport name is not specified in the receiver configuration");
        }
        String className = transport.getAttributeValue(new QName("class"));
        if (className == null || "".equals(className)) {
            throw new DeploymentException("Class name is not specified in the receiver configuration");
        }
        TransportOutDescription transportOut = new TransportOutDescription(name);
        if (init) {
            try {
                Class<?> clazz = TransportBuilderUtils.class.getClassLoader().loadClass(className);
                TransportSender sender = (TransportSender)clazz.newInstance();
                transportOut.setSender(sender);
            }
            catch (Exception e) {
                throw new DeploymentException("Error while initializing transport sender", (Throwable)e);
            }
        }
        Iterator itr = transport.getChildrenWithName(new QName("parameter"));
        TransportBuilderUtils.processParameters(itr, (ParameterInclude)transportOut);
        return transportOut;
    }

    private static void processParameters(Iterator parameters, ParameterInclude parameterInclude) throws DeploymentException {
        if (parameters == null) {
            return;
        }
        while (parameters.hasNext()) {
            OMElement parameterElement = (OMElement)parameters.next();
            Parameter parameter = new Parameter();
            parameter.setParameterElement(parameterElement);
            OMAttribute paramName = parameterElement.getAttribute(new QName("name"));
            if (paramName == null) {
                throw new DeploymentException(Messages.getMessage((String)"badparaagu", (String)parameterElement.toString()));
            }
            parameter.setName(paramName.getAttributeValue());
            OMElement paramValue = parameterElement.getFirstElement();
            if (paramValue != null) {
                parameter.setValue((Object)parameterElement);
                parameter.setParameterType(2);
            } else {
                String paratextValue = parameterElement.getText();
                parameter.setValue((Object)paratextValue);
                parameter.setParameterType(1);
            }
            OMAttribute paramLocked = parameterElement.getAttribute(new QName("locked"));
            if (paramLocked != null) {
                String lockedValue = paramLocked.getAttributeValue();
                if ("true".equals(lockedValue)) {
                    parameter.setLocked(true);
                } else {
                    parameter.setLocked(false);
                }
            }
            try {
                parameterInclude.addParameter(parameter);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException((Throwable)axisFault);
            }
        }
    }

    public static OMElement serializeTransportListener(TransportInDescription transport) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement transportReceiver = fac.createOMElement(new QName("transportReceiver"));
        transportReceiver.addAttribute("name", transport.getName(), null);
        transportReceiver.addAttribute("class", transport.getReceiver().getClass().getName(), null);
        TransportBuilderUtils.serializeParameters((ParameterInclude)transport, transportReceiver, fac);
        return transportReceiver;
    }

    public static OMElement serializeTransportSender(TransportOutDescription transport) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement transportReceiver = fac.createOMElement(new QName("transportSender"));
        transportReceiver.addAttribute("name", transport.getName(), null);
        transportReceiver.addAttribute("class", transport.getSender().getClass().getName(), null);
        TransportBuilderUtils.serializeParameters((ParameterInclude)transport, transportReceiver, fac);
        return transportReceiver;
    }

    private static void serializeParameters(ParameterInclude pInclude, OMElement parent, OMFactory fac) {
        ArrayList params = pInclude.getParameters();
        for (Parameter p : params) {
            parent.addChild((OMNode)TransportBuilderUtils.serializeParameter(p, fac));
        }
    }

    public static OMElement serializeParameter(Parameter p, OMFactory fac) {
        if (p.getParameterElement() != null) {
            return p.getParameterElement();
        }
        OMElement paramElement = fac.createOMElement(new QName("parameter"));
        paramElement.addAttribute("name", p.getName(), null);
        if (p.getValue() instanceof OMElement) {
            paramElement.addChild((OMNode)((OMElement)p.getValue()));
        } else {
            paramElement.setText(p.getValue().toString());
        }
        return paramElement;
    }

    public static Parameter toAxisParameter(TransportParameter parameter) throws XMLStreamException {
        Parameter p = new Parameter();
        p.setName(parameter.getName());
        OMElement paramElement = AXIOMUtil.stringToOM((String)parameter.getParamElement());
        p.setParameterElement(paramElement);
        if (paramElement.getFirstElement() != null) {
            p.setValue((Object)paramElement);
            p.setParameterType(2);
        } else {
            p.setValue((Object)paramElement.getText());
            p.setParameterType(1);
        }
        return p;
    }

    public static OMElement parseTransportConfiguration(String transport, URL url, boolean listener) throws Exception {
        String carbonHome = System.getProperty("carbon.home");
        File configFile = new File(carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + transport + "-config");
        InputStream configStream = configFile.exists() ? new FileInputStream(configFile) : url.openStream();
        if (configStream != null) {
            StAXOMBuilder builder = new StAXOMBuilder(configStream);
            OMElement doc = builder.getDocumentElement();
            if (listener) {
                return doc.getFirstChildWithName(new QName("transportReceiver"));
            }
            return doc.getFirstChildWithName(new QName("transportSender"));
        }
        return null;
    }
}

