/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.session;

import java.util.Map;
import java.util.Set;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.catalina.tribes.Member;
import org.wso2.carbon.core.session.CarbonTomcatClusterableSessionManager;

public class CarbonTomcatSessionMessage
extends ClusteringMessage
implements SessionMessage {
    private static final long serialVersionUID = 1L;
    private int mEvtType = -1;
    private byte[] mSession;
    private String mSessionID;
    private String mContextName;
    private long serializationTimestamp;
    private boolean timestampSet = false;
    private String uniqueId;
    protected transient Member address;

    public CarbonTomcatSessionMessage() {
    }

    private CarbonTomcatSessionMessage(String contextName, int eventtype, byte[] session, String sessionID) {
        this.mEvtType = eventtype;
        this.mSession = session;
        this.mSessionID = sessionID;
        this.mContextName = contextName;
        this.uniqueId = sessionID;
    }

    public CarbonTomcatSessionMessage(String contextName, int eventtype, byte[] session, String sessionID, String uniqueID) {
        this(contextName, eventtype, session, sessionID);
        this.uniqueId = uniqueID;
    }

    public int getEventType() {
        return this.mEvtType;
    }

    public byte[] getSession() {
        return this.mSession;
    }

    public String getSessionID() {
        return this.mSessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(long time) {
        CarbonTomcatSessionMessage carbonTomcatSessionMessage = this;
        synchronized (carbonTomcatSessionMessage) {
            if (!this.timestampSet) {
                this.serializationTimestamp = time;
                this.timestampSet = true;
            }
        }
    }

    public long getTimestamp() {
        return this.serializationTimestamp;
    }

    public String getEventTypeString() {
        switch (this.mEvtType) {
            case 1: {
                return "SESSION-MODIFIED";
            }
            case 2: {
                return "SESSION-EXPIRED";
            }
            case 3: {
                return "SESSION-ACCESSED";
            }
            case 4: {
                return "SESSION-GET-ALL";
            }
            case 13: {
                return "SESSION-DELTA";
            }
            case 12: {
                return "ALL-SESSION-DATA";
            }
            case 14: {
                return "SESSION-STATE-TRANSFERED";
            }
            case 15: {
                return "SESSION-ID-CHANGED";
            }
            case 16: {
                return "NO-CONTEXT-MANAGER";
            }
        }
        return "UNKNOWN-EVENT-TYPE";
    }

    public String getContextName() {
        return this.mContextName;
    }

    public Member getAddress() {
        return this.address;
    }

    public void setAddress(Member member) {
        this.address = member;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String toString() {
        return this.getEventTypeString() + "#" + this.getContextName() + "#" + this.getSessionID();
    }

    public ClusteringCommand getResponse() {
        return new CarbonTomcatSessionMessage();
    }

    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        CarbonTomcatClusterableSessionManager manager;
        String context;
        Map sessionManagerMap = (Map)configContext.getProperty("CarbonTomcatSessionManagerMap");
        if (sessionManagerMap != null && !sessionManagerMap.isEmpty() && this.getContextName() != null && (context = this.getWebappContext(this.getContextName(), sessionManagerMap.keySet())) != null && (manager = (CarbonTomcatClusterableSessionManager)((Object)sessionManagerMap.get(context))) != null) {
            manager.clusterMessageReceived((ClusterMessage)this);
        }
    }

    private String getWebappContext(String path, Set<String> contextSet) {
        for (String key : contextSet) {
            if (!path.contains(key)) continue;
            return key;
        }
        return null;
    }
}

