/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal.permission.update;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.realm.RegistryRealm;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.authorization.JDBCAuthorizationManager;
import org.wso2.carbon.utils.AuthenticationObserver;

public class PermissionUpdater {
    private static final Log log = LogFactory.getLog(PermissionUpdater.class);
    private static final String PERM_TREE_TIMESTAMP_LOC = "/repository/components/org.wso2.carbon.user.mgt/updatedTime";
    private static final String PERM_TREE_TIMESTAMP_PROP = "timestamp";
    private static ConcurrentHashMap<Integer, Long> permTreeModifiedTimeStampMap = new ConcurrentHashMap();
    private static CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();

    public static void update(int tenantId) {
        try {
            PermissionUpdater.initializeRegistry(tenantId);
            RegistryService registryService = dataHolder.getRegistryService();
            AuthorizationManager authzManager = PermissionUpdater.getAuthzManager(tenantId, registryService);
            if (authzManager instanceof JDBCAuthorizationManager) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating  permission cache for tenant: " + tenantId));
                }
                ((JDBCAuthorizationManager)authzManager).populatePermissionTreeFromDB();
            }
            UserRegistry registry = registryService.getGovernanceSystemRegistry(tenantId);
            Long lastModifiedTime = System.currentTimeMillis();
            if (registry.resourceExists(PERM_TREE_TIMESTAMP_LOC)) {
                Resource resource = registry.get(PERM_TREE_TIMESTAMP_LOC);
                lastModifiedTime = new Long(resource.getProperty(PERM_TREE_TIMESTAMP_PROP).trim());
            } else {
                Resource resource = registry.newResource();
                resource.setProperty(PERM_TREE_TIMESTAMP_PROP, String.valueOf(lastModifiedTime));
                registry.put(PERM_TREE_TIMESTAMP_LOC, resource);
            }
            permTreeModifiedTimeStampMap.put(tenantId, lastModifiedTime);
            log.info((Object)("Permission cache updated for tenant " + tenantId));
        }
        catch (Exception e) {
            log.error((Object)("Error when updating the permission cache for tenant : " + tenantId), (Throwable)e);
        }
    }

    private static AuthorizationManager getAuthzManager(int tenantId, RegistryService registryService) throws UserStoreException, RegistryException {
        AuthorizationManager authznManager = ((RegistryRealm)registryService.getUserRealm(tenantId)).getRealm().getAuthorizationManager();
        return authznManager;
    }

    public static void remove(int tenantId) {
        try {
            RegistryService registryService = dataHolder.getRegistryService();
            AuthorizationManager authzManager = PermissionUpdater.getAuthzManager(tenantId, registryService);
            if (authzManager instanceof JDBCAuthorizationManager) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating  permission cache for tenant: " + tenantId));
                }
                ((JDBCAuthorizationManager)authzManager).clearPermissionTree();
            }
            permTreeModifiedTimeStampMap.remove(tenantId);
        }
        catch (Exception e) {
            log.error((Object)("Error when clearing the permission cache for tenant : " + tenantId), (Throwable)e);
        }
    }

    public static boolean needsUpdating(int tenantId) throws Exception {
        RegistryService registryService = dataHolder.getRegistryService();
        UserRegistry registry = registryService.getGovernanceSystemRegistry(tenantId);
        if (!registry.resourceExists(PERM_TREE_TIMESTAMP_LOC)) {
            return false;
        }
        if (permTreeModifiedTimeStampMap.containsKey(tenantId)) {
            Resource resource = registry.get(PERM_TREE_TIMESTAMP_LOC);
            Long registryTimeStamp = new Long(resource.getProperty(PERM_TREE_TIMESTAMP_PROP).trim());
            Long localTimeStamp = permTreeModifiedTimeStampMap.get(tenantId);
            return localTimeStamp < registryTimeStamp;
        }
        return true;
    }

    private static void initializeRegistry(int tenantId) {
        BundleContext bundleContext = dataHolder.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).startedAuthentication(tenantId);
                }
            }
            tracker.close();
        }
    }
}

