/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.globus.common.CoGProperties;
import org.globus.net.PortRange;

public class DatagramSocketFactory {
    private static DatagramSocketFactory defaultFactory = null;
    private PortRange portRange = PortRange.getUdpSourceInstance();

    protected DatagramSocketFactory() {
    }

    public static synchronized DatagramSocketFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = new DatagramSocketFactory();
        }
        return defaultFactory;
    }

    public DatagramSocket createDatagramSocket() throws IOException {
        return this.createDatagramSocket(0, null);
    }

    public DatagramSocket createDatagramSocket(int port) throws IOException {
        return this.createDatagramSocket(port, null);
    }

    public DatagramSocket createDatagramSocket(int port, InetAddress localAddr) throws IOException {
        if (this.portRange.isEnabled() && port == 0) {
            return new PrDatagramSocket(this.createDatagramSocket(localAddr));
        }
        DatagramSocket socket = new DatagramSocket(port, localAddr);
        socket.setSoTimeout(CoGProperties.getDefault().getSocketTimeout());
        return new DatagramSocket(port, localAddr);
    }

    private DatagramSocket createDatagramSocket(InetAddress localAddr) throws IOException {
        DatagramSocket socket = null;
        int localPort = 0;
        while (true) {
            localPort = this.portRange.getFreePort(localPort);
            try {
                socket = new DatagramSocket(localPort, localAddr);
                socket.setSoTimeout(CoGProperties.getDefault().getSocketTimeout());
                this.portRange.setUsed(localPort);
                return socket;
            }
            catch (BindException e) {
                ++localPort;
                continue;
            }
            break;
        }
    }

    class PrDatagramSocket
    extends DatagramSocket {
        private DatagramSocket socket;

        public PrDatagramSocket(DatagramSocket socket) throws SocketException {
            this.socket = socket;
        }

        public void connect(InetAddress address, int port) {
            this.socket.connect(address, port);
        }

        public void disconnect() {
            this.socket.disconnect();
        }

        public InetAddress getInetAddress() {
            return this.socket.getInetAddress();
        }

        public int getPort() {
            return this.socket.getPort();
        }

        public void send(DatagramPacket p) throws IOException {
            this.socket.send(p);
        }

        public void receive(DatagramPacket p) throws IOException {
            this.socket.receive(p);
        }

        public InetAddress getLocalAddress() {
            return this.socket.getLocalAddress();
        }

        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        public void setSoTimeout(int timeout) throws SocketException {
            this.socket.setSoTimeout(timeout);
        }

        public int getSoTimeout() throws SocketException {
            return this.socket.getSoTimeout();
        }

        public void setSendBufferSize(int size) throws SocketException {
            this.socket.setSendBufferSize(size);
        }

        public int getSendBufferSize() throws SocketException {
            return this.socket.getSendBufferSize();
        }

        public void setReceiveBufferSize(int size) throws SocketException {
            this.socket.setReceiveBufferSize(size);
        }

        public int getReceiveBufferSize() throws SocketException {
            return this.socket.getReceiveBufferSize();
        }

        public void close() {
            int port = this.getLocalPort();
            this.socket.close();
            if (port != -1) {
                DatagramSocketFactory.this.portRange.free(port);
            }
        }
    }
}

