/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.QueueStatus;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueStatusResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(QueueStatusResource.class);
    private String hostName;
    private String queueName;
    private Long time;
    private Boolean queueUp;
    private Integer runningJobs;
    private Integer queuedJobs;

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public Boolean getQueueUp() {
        return this.queueUp;
    }

    public void setQueueUp(Boolean queueUp) {
        this.queueUp = queueUp;
    }

    public Integer getRunningJobs() {
        return this.runningJobs;
    }

    public void setRunningJobs(Integer runningJobs) {
        this.runningJobs = runningJobs;
    }

    public Integer getQueuedJobs() {
        return this.queuedJobs;
    }

    public void setQueuedJobs(Integer queuedJobs) {
        this.queuedJobs = queuedJobs;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        throw new RegistryException("Method not supported...!!!");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        throw new RegistryException("Method not supported...!!!");
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        throw new RegistryException("Method not supported...!!!");
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        ArrayList<ExperimentCatResource> result = new ArrayList<ExperimentCatResource>();
        EntityManager em = null;
        try {
            String query = "SELECT q from QueueStatus q WHERE q.time IN (SELECT MAX(q2.time) FROM QueueStatus q2 GROUP BY q2.hostName, q2.queueName)";
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = em.createQuery(query);
            List resultList = q.getResultList();
            for (Object o : resultList) {
                QueueStatus queueStatus = (QueueStatus)o;
                QueueStatusResource queueStatusResource = new QueueStatusResource();
                queueStatusResource.setHostName(queueStatus.getHostName());
                queueStatusResource.setQueueName(queueStatus.getQueueName());
                queueStatusResource.setTime(queueStatus.getTime());
                queueStatusResource.setQueueUp(queueStatus.getQueueUp());
                queueStatusResource.setQueuedJobs(queueStatus.getQueuedJobs());
                queueStatusResource.setRunningJobs(queueStatus.getRunningJobs());
                result.add(queueStatusResource);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            QueueStatus queueStatus = new QueueStatus();
            queueStatus.setHostName(this.hostName);
            queueStatus.setQueueName(this.queueName);
            queueStatus.setTime(this.time);
            queueStatus.setQueueUp(this.queueUp);
            queueStatus.setRunningJobs(this.runningJobs);
            queueStatus.setQueuedJobs(this.queuedJobs);
            em.getTransaction().begin();
            em.persist((Object)queueStatus);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

