/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Job;
import org.apache.airavata.registry.core.experiment.catalog.model.JobPK;
import org.apache.airavata.registry.core.experiment.catalog.model.JobStatus;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.JobStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.Utils;
import org.apache.airavata.registry.core.experiment.catalog.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(JobResource.class);
    private String jobId;
    private String taskId;
    private String processId;
    private String jobDescription;
    private Timestamp creationTime;
    private String computeResourceConsumed;
    private String jobName;
    private String workingDir;
    private String stdOut;
    private String stdErr;
    private int exitCode;

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public String getComputeResourceConsumed() {
        return this.computeResourceConsumed;
    }

    public void setComputeResourceConsumed(String computeResourceConsumed) {
        this.computeResourceConsumed = computeResourceConsumed;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getStdOut() {
        return this.stdOut;
    }

    public void setStdOut(String stdOut) {
        this.stdOut = stdOut;
    }

    public String getStdErr() {
        return this.stdErr;
    }

    public void setStdErr(String stderr) {
        this.stdErr = stderr;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        switch (type) {
            case JOB_STATUS: {
                JobStatusResource jobStatusResource = new JobStatusResource();
                jobStatusResource.setJobId(this.jobId);
                return jobStatusResource;
            }
        }
        logger.error("Unsupported resource type for job details data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case JOB_STATUS: {
                    QueryGenerator generator = new QueryGenerator("JobStatus", new Object[0][]);
                    generator.setParameter("statusId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for job details resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case JOB_STATUS: {
                    QueryGenerator generator = new QueryGenerator("JobStatus", new Object[0][]);
                    generator.setParameter("statusId", name);
                    Query q = generator.selectQuery(em);
                    JobStatus status = (JobStatus)q.getSingleResult();
                    JobStatusResource statusResource = (JobStatusResource)Utils.getResource(ResourceType.JOB_STATUS, status);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    JobStatusResource jobStatusResource = statusResource;
                    return jobStatusResource;
                }
            }
            try {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported resource type for Job resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for Job resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        ArrayList<ExperimentCatResource> resourceList = new ArrayList<ExperimentCatResource>();
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case JOB_STATUS: {
                    QueryGenerator generator = new QueryGenerator("JobStatus", new Object[0][]);
                    generator.setParameter("jobId", this.jobId);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        JobStatus jobStatus = (JobStatus)result;
                        JobStatusResource jobStatusResource = (JobStatusResource)Utils.getResource(ResourceType.JOB_STATUS, jobStatus);
                        resourceList.add(jobStatusResource);
                    }
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for job resource.", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            JobPK jobPK = new JobPK();
            jobPK.setJobId(this.jobId);
            jobPK.setTaskId(this.taskId);
            Job existingJob = (Job)em.find(Job.class, (Object)jobPK);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Job job = existingJob == null ? new Job() : existingJob;
            job.setJobId(this.jobId);
            job.setTaskId(this.taskId);
            job.setProcessId(this.processId);
            if (this.jobDescription != null) {
                job.setJobDescription(this.jobDescription.toCharArray());
            }
            if (this.stdOut != null) {
                job.setStdOut(this.stdOut.toCharArray());
            }
            if (this.stdErr != null) {
                job.setStdErr(this.stdErr.toCharArray());
            }
            job.setCreationTime(this.creationTime);
            job.setComputeResourceConsumed(this.computeResourceConsumed);
            job.setJobName(this.jobName);
            job.setWorkingDir(this.workingDir);
            job.setExitCode(this.exitCode);
            if (existingJob == null) {
                em.persist((Object)job);
            } else {
                em.merge((Object)job);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public List<JobStatusResource> getJobStatuses() throws RegistryException {
        ArrayList<JobStatusResource> jobStatusResources = new ArrayList<JobStatusResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.JOB_STATUS);
        for (ExperimentCatResource resource : resources) {
            JobStatusResource statusResource = (JobStatusResource)resource;
            jobStatusResources.add(statusResource);
        }
        return jobStatusResources;
    }

    public JobStatusResource getJobStatus() throws RegistryException {
        List<JobStatusResource> jobStatusResources = this.getJobStatuses();
        if (jobStatusResources.size() == 0) {
            return null;
        }
        JobStatusResource max = jobStatusResources.get(0);
        for (int i = 1; i < jobStatusResources.size(); ++i) {
            if (!(jobStatusResources.get(i).getTimeOfStateChange().after(max.getTimeOfStateChange()) || jobStatusResources.get(i).getTimeOfStateChange().equals(max.getTimeOfStateChange()) && jobStatusResources.get(i).getState().equals(JobState.COMPLETE.toString()) || jobStatusResources.get(i).getTimeOfStateChange().equals(max.getTimeOfStateChange()) && jobStatusResources.get(i).getState().equals(JobState.FAILED.toString())) && (!jobStatusResources.get(i).getTimeOfStateChange().equals(max.getTimeOfStateChange()) || !jobStatusResources.get(i).getState().equals(JobState.CANCELED.toString()))) continue;
            max = jobStatusResources.get(i);
        }
        return max;
    }
}

