/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.model.status.ExperimentState;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Experiment;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentError;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentInput;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentOutput;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentStatus;
import org.apache.airavata.registry.core.experiment.catalog.model.Process;
import org.apache.airavata.registry.core.experiment.catalog.model.UserConfigurationData;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentErrorResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentInputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentOutputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.UserConfigurationDataResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.Utils;
import org.apache.airavata.registry.core.experiment.catalog.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentResource.class);
    private String experimentId;
    private String projectId;
    private String gatewayId;
    private String experimentType;
    private String userName;
    private String experimentName;
    private Timestamp creationTime;
    private String description;
    private String executionId;
    private String gatewayExecutionId;
    private String gatewayInstanceId;
    private boolean enableEmailNotification;
    private String emailAddresses;

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getExperimentType() {
        return this.experimentType;
    }

    public void setExperimentType(String experimentType) {
        this.experimentType = experimentType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public void setExperimentName(String experimentName) {
        this.experimentName = experimentName;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getGatewayInstanceId() {
        return this.gatewayInstanceId;
    }

    public void setGatewayInstanceId(String gatewayInstanceId) {
        this.gatewayInstanceId = gatewayInstanceId;
    }

    public String getGatewayExecutionId() {
        return this.gatewayExecutionId;
    }

    public void setGatewayExecutionId(String gatewayExecutionId) {
        this.gatewayExecutionId = gatewayExecutionId;
    }

    public boolean getEnableEmailNotification() {
        return this.enableEmailNotification;
    }

    public void setEnableEmailNotification(boolean enableEmailNotification) {
        this.enableEmailNotification = enableEmailNotification;
    }

    public String getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        switch (type) {
            case EXPERIMENT_ERROR: {
                ExperimentErrorResource errorResource = new ExperimentErrorResource();
                errorResource.setExperimentId(this.experimentId);
                return errorResource;
            }
            case EXPERIMENT_STATUS: {
                ExperimentStatusResource statusResource = new ExperimentStatusResource();
                statusResource.setExperimentId(this.experimentId);
                return statusResource;
            }
            case EXPERIMENT_INPUT: {
                ExperimentInputResource experimentInputResource = new ExperimentInputResource();
                experimentInputResource.setExperimentId(this.experimentId);
                return experimentInputResource;
            }
            case EXPERIMENT_OUTPUT: {
                ExperimentOutputResource outputResource = new ExperimentOutputResource();
                outputResource.setExperimentId(this.experimentId);
                return outputResource;
            }
            case USER_CONFIGURATION_DATA: {
                UserConfigurationDataResource configurationDataResource = new UserConfigurationDataResource();
                configurationDataResource.setExperimentId(this.experimentId);
                return configurationDataResource;
            }
            case PROCESS: {
                ProcessResource processResource = new ProcessResource();
                processResource.setExperimentId(this.experimentId);
                return processResource;
            }
        }
        logger.error("Unsupported resource type for experiment resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for experiment resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case EXPERIMENT_ERROR: {
                    QueryGenerator generator = new QueryGenerator("ExperimentError", new Object[0][]);
                    generator.setParameter("errorId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case EXPERIMENT_STATUS: {
                    QueryGenerator generator = new QueryGenerator("ExperimentStatus", new Object[0][]);
                    generator.setParameter("experimentId", this.experimentId);
                    generator.setParameter("statusId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case EXPERIMENT_INPUT: {
                    QueryGenerator generator = new QueryGenerator("ExperimentInput", new Object[0][]);
                    generator.setParameter("inputName", name);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case EXPERIMENT_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("ExperimentOutput", new Object[0][]);
                    generator.setParameter("outputName", name);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case USER_CONFIGURATION_DATA: {
                    QueryGenerator generator = new QueryGenerator("UserConfigurationData", new Object[0][]);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case PROCESS: {
                    QueryGenerator generator = new QueryGenerator("Process", new Object[0][]);
                    generator.setParameter("processId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for process detail resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case EXPERIMENT_STATUS: {
                    QueryGenerator generator = new QueryGenerator("ExperimentStatus", new Object[0][]);
                    generator.setParameter("statusId", name);
                    Query q = generator.selectQuery(em);
                    ExperimentStatus status = (ExperimentStatus)q.getSingleResult();
                    ExperimentStatusResource statusResource = (ExperimentStatusResource)Utils.getResource(ResourceType.EXPERIMENT_STATUS, status);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ExperimentStatusResource experimentStatusResource = statusResource;
                    return experimentStatusResource;
                }
                case EXPERIMENT_ERROR: {
                    QueryGenerator generator = new QueryGenerator("ExperimentError", new Object[0][]);
                    generator.setParameter("errorId", name);
                    Query q = generator.selectQuery(em);
                    ExperimentError experimentError = (ExperimentError)q.getSingleResult();
                    ExperimentErrorResource processErrorResource = (ExperimentErrorResource)Utils.getResource(ResourceType.EXPERIMENT_ERROR, experimentError);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ExperimentErrorResource experimentErrorResource = processErrorResource;
                    return experimentErrorResource;
                }
                case EXPERIMENT_INPUT: {
                    QueryGenerator generator = new QueryGenerator("ExperimentInput", new Object[0][]);
                    generator.setParameter("inputName", name);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.selectQuery(em);
                    ExperimentInput experimentInput = (ExperimentInput)q.getSingleResult();
                    ExperimentInputResource experimentInputResource = (ExperimentInputResource)Utils.getResource(ResourceType.EXPERIMENT_INPUT, experimentInput);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ExperimentInputResource experimentInputResource2 = experimentInputResource;
                    return experimentInputResource2;
                }
                case EXPERIMENT_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("ExperimentOutput", new Object[0][]);
                    generator.setParameter("outputName", name);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.selectQuery(em);
                    ExperimentOutput experimentOutput = (ExperimentOutput)q.getSingleResult();
                    ExperimentOutputResource outputResource = (ExperimentOutputResource)Utils.getResource(ResourceType.EXPERIMENT_OUTPUT, experimentOutput);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ExperimentOutputResource experimentOutputResource = outputResource;
                    return experimentOutputResource;
                }
                case USER_CONFIGURATION_DATA: {
                    QueryGenerator generator = new QueryGenerator("UserConfigurationData", new Object[0][]);
                    generator.setParameter("experimentId", name);
                    Query q = generator.selectQuery(em);
                    UserConfigurationData configurationData = (UserConfigurationData)q.getSingleResult();
                    UserConfigurationDataResource configurationDataResource = (UserConfigurationDataResource)Utils.getResource(ResourceType.USER_CONFIGURATION_DATA, configurationData);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    UserConfigurationDataResource userConfigurationDataResource = configurationDataResource;
                    return userConfigurationDataResource;
                }
                case PROCESS: {
                    QueryGenerator generator = new QueryGenerator("Process", new Object[0][]);
                    generator.setParameter("processId", name);
                    Query q = generator.selectQuery(em);
                    Process process = (Process)q.getSingleResult();
                    ProcessResource processResource = (ProcessResource)Utils.getResource(ResourceType.PROCESS, process);
                    em.getTransaction().commit();
                    if (em.isOpen()) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        em.close();
                    }
                    ProcessResource processResource2 = processResource;
                    return processResource2;
                }
            }
            try {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported resource type for experiment resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for experiment resource.");
            }
            catch (Exception e) {
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        ArrayList<ExperimentCatResource> resourceList = new ArrayList<ExperimentCatResource>();
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case EXPERIMENT_INPUT: {
                    QueryGenerator generator = new QueryGenerator("ExperimentInput", new Object[0][]);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ExperimentInput experimentInput = (ExperimentInput)result;
                        ExperimentInputResource experimentInputResource = (ExperimentInputResource)Utils.getResource(ResourceType.EXPERIMENT_INPUT, experimentInput);
                        resourceList.add(experimentInputResource);
                    }
                    break;
                }
                case EXPERIMENT_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("ExperimentOutput", new Object[0][]);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ExperimentOutput experimentOutput = (ExperimentOutput)result;
                        ExperimentOutputResource experimentOutputResource = (ExperimentOutputResource)Utils.getResource(ResourceType.EXPERIMENT_OUTPUT, experimentOutput);
                        resourceList.add(experimentOutputResource);
                    }
                    break;
                }
                case PROCESS: {
                    QueryGenerator generator = new QueryGenerator("Process", new Object[0][]);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Process process = (Process)result;
                        ProcessResource processResource = (ProcessResource)Utils.getResource(ResourceType.PROCESS, process);
                        resourceList.add(processResource);
                    }
                    break;
                }
                case EXPERIMENT_ERROR: {
                    QueryGenerator generator = new QueryGenerator("ExperimentError", new Object[0][]);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ExperimentError experimentError = (ExperimentError)result;
                        ExperimentErrorResource experimentErrorResource = (ExperimentErrorResource)Utils.getResource(ResourceType.EXPERIMENT_ERROR, experimentError);
                        resourceList.add(experimentErrorResource);
                    }
                    break;
                }
                case EXPERIMENT_STATUS: {
                    QueryGenerator generator = new QueryGenerator("ExperimentStatus", new Object[0][]);
                    generator.setParameter("experimentId", this.experimentId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ExperimentStatus experimentStatus = (ExperimentStatus)result;
                        ExperimentStatusResource experimentStatusResource = (ExperimentStatusResource)Utils.getResource(ResourceType.EXPERIMENT_STATUS, experimentStatus);
                        resourceList.add(experimentStatusResource);
                    }
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for experiment resource.", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            Experiment existingExp = (Experiment)em.find(Experiment.class, (Object)this.experimentId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Experiment experiment = existingExp == null ? new Experiment() : existingExp;
            experiment.setExperimentId(this.experimentId);
            experiment.setProjectId(this.projectId);
            experiment.setGatewayId(this.gatewayId);
            experiment.setExperimentType(this.experimentType);
            experiment.setUserName(this.userName);
            experiment.setExperimentName(this.experimentName);
            experiment.setCreationTime(this.creationTime);
            experiment.setDescription(this.description);
            experiment.setExecutionId(this.executionId);
            experiment.setGatewayInstanceId(this.gatewayInstanceId);
            experiment.setGatewayExecutionId(this.gatewayExecutionId);
            experiment.setEnableEmailNotification(this.enableEmailNotification);
            experiment.setEmailAddresses(this.emailAddresses);
            if (existingExp == null) {
                em.persist((Object)experiment);
            } else {
                em.merge((Object)experiment);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public List<ExperimentInputResource> getExperimentInputs() throws RegistryException {
        ArrayList<ExperimentInputResource> experimentInputResources = new ArrayList<ExperimentInputResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.EXPERIMENT_INPUT);
        for (ExperimentCatResource resource : resources) {
            ExperimentInputResource inputResource = (ExperimentInputResource)resource;
            experimentInputResources.add(inputResource);
        }
        return experimentInputResources;
    }

    public List<ExperimentOutputResource> getExperimentOutputs() throws RegistryException {
        ArrayList<ExperimentOutputResource> outputResources = new ArrayList<ExperimentOutputResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.EXPERIMENT_OUTPUT);
        for (ExperimentCatResource resource : resources) {
            ExperimentOutputResource outputResource = (ExperimentOutputResource)resource;
            outputResources.add(outputResource);
        }
        return outputResources;
    }

    public List<ExperimentStatusResource> getExperimentStatuses() throws RegistryException {
        ArrayList<ExperimentStatusResource> experimentStatusResources = new ArrayList<ExperimentStatusResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.EXPERIMENT_STATUS);
        for (ExperimentCatResource resource : resources) {
            ExperimentStatusResource statusResource = (ExperimentStatusResource)resource;
            experimentStatusResources.add(statusResource);
        }
        return experimentStatusResources;
    }

    public ExperimentStatusResource getExperimentStatus() throws RegistryException {
        List<ExperimentStatusResource> experimentStatusResources = this.getExperimentStatuses();
        if (experimentStatusResources.size() == 0) {
            return null;
        }
        ExperimentStatusResource max = experimentStatusResources.get(0);
        for (int i = 1; i < experimentStatusResources.size(); ++i) {
            Timestamp timeOfStateChange = experimentStatusResources.get(i).getTimeOfStateChange();
            if (timeOfStateChange == null || !(timeOfStateChange.after(max.getTimeOfStateChange()) || timeOfStateChange.equals(max.getTimeOfStateChange()) && experimentStatusResources.get(i).getState().equals(ExperimentState.COMPLETED.toString()) || timeOfStateChange.equals(max.getTimeOfStateChange()) && experimentStatusResources.get(i).getState().equals(ExperimentState.FAILED.toString())) && (!timeOfStateChange.equals(max.getTimeOfStateChange()) || !experimentStatusResources.get(i).getState().equals(ExperimentState.CANCELED.toString()))) continue;
            max = experimentStatusResources.get(i);
        }
        return max;
    }

    public List<ExperimentErrorResource> getExperimentErrors() throws RegistryException {
        ArrayList<ExperimentErrorResource> experimentErrorResources = new ArrayList<ExperimentErrorResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.EXPERIMENT_ERROR);
        for (ExperimentCatResource resource : resources) {
            ExperimentErrorResource errorResource = (ExperimentErrorResource)resource;
            experimentErrorResources.add(errorResource);
        }
        return experimentErrorResources;
    }

    public ExperimentErrorResource getExperimentError() throws RegistryException {
        List<ExperimentErrorResource> experimentErrorResources = this.getExperimentErrors();
        if (experimentErrorResources.size() == 0) {
            return null;
        }
        ExperimentErrorResource max = experimentErrorResources.get(0);
        for (int i = 1; i < experimentErrorResources.size(); ++i) {
            if (!experimentErrorResources.get(i).getCreationTime().after(max.getCreationTime())) continue;
            max = experimentErrorResources.get(i);
        }
        return max;
    }

    public UserConfigurationDataResource getUserConfigurationDataResource() throws RegistryException {
        ExperimentCatResource resource = this.get(ResourceType.USER_CONFIGURATION_DATA, this.experimentId);
        return (UserConfigurationDataResource)resource;
    }

    public List<ProcessResource> getProcessList() throws RegistryException {
        ArrayList<ProcessResource> processResources = new ArrayList<ProcessResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.PROCESS);
        for (ExperimentCatResource resource : resources) {
            ProcessResource processResource = (ProcessResource)resource;
            processResources.add(processResource);
        }
        return processResources;
    }

    public ProcessResource getProcess(String processID) throws RegistryException {
        ExperimentCatResource resource = this.get(ResourceType.PROCESS, processID);
        return (ProcessResource)resource;
    }
}

