/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.model;

import java.sql.Timestamp;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.airavata.registry.core.experiment.catalog.model.Experiment;
import org.apache.airavata.registry.core.experiment.catalog.model.Gateway;
import org.apache.airavata.registry.core.experiment.catalog.model.ProjectUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="PROJECT")
public class Project {
    private static final Logger logger = LoggerFactory.getLogger(Project.class);
    private String gatewayId;
    private String userName;
    private String projectName;
    private String projectId;
    private String description;
    private Timestamp creationTime;
    private Collection<Experiment> experiments;
    private Gateway gateway;
    private Collection<ProjectUser> projectUsers;

    @Column(name="GATEWAY_ID")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    @Column(name="USER_NAME")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String ownerName) {
        this.userName = ownerName;
    }

    @Column(name="PROJECT_NAME")
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Id
    @Column(name="PROJECT_ID")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Column(name="DESCRIPTION")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="CREATION_TIME")
    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    @OneToMany(mappedBy="project")
    public Collection<Experiment> getExperiments() {
        return this.experiments;
    }

    public void setExperiments(Collection<Experiment> experimentByProjectId) {
        this.experiments = experimentByProjectId;
    }

    @ManyToOne
    @JoinColumn(name="GATEWAY_ID", referencedColumnName="GATEWAY_ID")
    public Gateway getGateway() {
        return this.gateway;
    }

    public void setGateway(Gateway gatewayByGatewayId) {
        this.gateway = gatewayByGatewayId;
    }

    @OneToMany(mappedBy="project")
    public Collection<ProjectUser> getProjectUsers() {
        return this.projectUsers;
    }

    public void setProjectUsers(Collection<ProjectUser> projectUsersByProjectId) {
        this.projectUsers = projectUsersByProjectId;
    }
}

